# === StarGate Payment Gateway for WooCommerce ===
Contributors: comprassibs
Tags: payments, woocommerce, blik, pay by link, sibs, credit card, visa, mastercard, payment gateway, apple pay, google pay
Stable tag: 2.16.4
PHP requires at least: 7.4
PHP tested up to: 8.3.x
Wordpress requires at least: 6.5
Wordpress tested up to: 6.8
WooCommerce requires at least: 7.4.1
WooCommerce tested up to: 10.3.x
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

Accept VISA, MasterCard, BLIK and Pay By Link with a single payment gateway solution.

# == Description ==

A ready-to-service e-commerce solution, with integrated checkout positioning and BackOffice for merchant management. An interface for various national and international payment methods.

*Why use SIBS Payments Gateway for WooCommerce?*

- Unique platform for payment methods and brands relevant to your customers, with PCI DSS security certification.
- Fraud prevention and detection in every channel and cards in the system.
- Web responsive hosted SIBS payment page allowing you not to process sensitive data.
- Allows the Acquirer choice for each payment method.
- From the authenticated registration, SIBS keep the card sensitive data, allowing One Click Shopping experience.
- Supports 3D Secure.
- And more!

*Integrated Checkout*

SIBS Payments Gateway Plugin for WooCommerce allows you to have an integrated checkout on your Web page, ensuring a good customer experience and better conversion rates.
Through COPYandPAY payment form direct integration in the shopping cart, you offer different payment methods to the customer in a safe way. 

*Monitoring and reporting tools*

The BackOffice allows you to view an activity summary in the entry page with given modules and configurable indicators, consult the transaction list with real time state updates, verify the transaction detail, act on a transaction (amount capture, transaction canceling and amount refund), activity monitoring through configurable reports (by period, payment method, operation type, etc...) and export visualized data or aggregated reports.

*Better Fraud protection*

*Integrated with the domestic banking system*

Integrated with national issuers, processing and in the interbank clearing system.

*Warranty*

The plugin is provided “as is” without warranty of any kind, expressed or implied. We shall not be liable for any damages, including but not limited to, direct, indirect, special, incidental or consequential damages or losses that occur out of the use or inability to use our products or support.
Before general release, the plugins are tested and guaranteed to function on basic installation of Wordpress and regular Woocommerce. We do not, and cannot, assure that that it will function with all third-party plugins or in all web browsers, therefore, we cannot be held responsible for any conflicts that may occur in your installation. 
It is our policy to support our plugins as best we can and we will provide support for third-party plugin conflicts at our discretion or as time allows. 
We are not responsible for any data loss or other damages that may occur as a result of installing our plugins.

*Acceptance*

By using the plugin you indicate that you have read and agreed and understood the terms above.
We reserve the right to change or modify the current terms.

# == Installation ==

In order to have the solution ready to use:

1.	Separately from the plugin installation you will need an agreement with the available Financial Institutions:
    - Caixa Geral de Depósitos
    - Millennium BCP
    - Santander
    - Banco BPI
    - Caixa Crédito Agrícola
    - SIBS Pagamentos
    - Others 
2.	Once the agreement is signed with the chosen Financial Institution, you can request your credentials to start accepting payments.
3.	Please contact SIBS to proceed:
    - Email - pagamentos@sibs.pt, paymentservices@sibs.pt
    - Phone - 217918703

# == Frequently Asked Questions ==

*Where can I find documentation?*

For help setting up and configuring, please refer to our user guide.

*How long does it take to start accepting payments?*

After the agreement is signed and the plugin is run to integrate the solution, enter the credentials to start accepting payments.

*What currencies can I use?*

Currently, only Euros.

*How long does it take the money to get to my account?*

The money will be deposited directly in your bank account (there are no wallets in the middle of the process) accordingly to the Bank clearing and settlement cycles.

# == Changelog ==

## v1.0.4
*Released on*
- 2022/11/23

*Stability*
- PHP: 7.2 to 7.4
- WordPress: 5.6 to 6.0
- WooCommerce: 6.0.0 to 7.0.0

*Changes*
- Added Pay By Link Kevin Payment


## v1.0.5
*Released on*
- 2022/12/20

*Stability*
- PHP: 7.2 to 7.4
- WordPress: 5.6 to 6.0
- WooCommerce: 6.0.0 to 7.0.0

*Changes*
- Improved comunication data for Kevin Payment


## v2.3.1
*Released on*
- 2023/03/08

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.1
- WooCommerce: 7.4.1 to 7.5.1

*Changes*
- Fixed to run in PHP 8
- Improved Order Layout
- Added Authorized Order Status
- Added Capture Rework
- Added Refund Rework
- Added New Translations


## v2.4.1
*Released on*
- 2023/03/15

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.1
- WooCommerce: 7.4.1 to 7.5.1

*Changes*
- Improved SIBS Configuration Layout
- Separated Pay By Link Kevin from Pay By Link Blue Media Configuration
- Implemented Webhooks Improvement
- Added Async Capture (Only webhook)
- Added Async Refund
- Added Migration data from version 1.0.5


## v2.4.2
*Released on*
- 2023/03/27

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.1
- WooCommerce: 7.4.1 to 7.5.1

*Changes*
- Updated production form url from https://api.sibsgateway.com/assets/js/widget.js to https://form.sibsgateway.com/assets/js/widget.js


## v2.4.3
*Released on*
- 2023/03/30

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.1
- WooCommerce: 7.4.1 to 7.5.1

*Changes*
- Resolved Virtual products shipping address problem
- Added Payment Method translation
- Resolved Missing mail function notification


## v2.4.4
*Released on*
- 2023/03/30

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.1
- WooCommerce: 7.4.1 to 7.5.1

*Changes*
- Added Prevent email library validation to stop the plugin
- Updated message of email library validation


## v2.4.5
*Released on*
- 2023/04/04

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.1
- WooCommerce: 7.4.1 to 7.5.1

*Changes*
- Removed SIBS label from payment method options
- Updated polish translations


## v2.4.6
*Released on*
- 2023/05/15

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.2.1
- WooCommerce: 7.4.1 to 7.7.0

*Changes*
- Added Credit Card Default values and removing it from need to setup


## v2.4.7
*Released on*
- 2023/05/16

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.2.1
- WooCommerce: 7.4.1 to 7.7.0

*Changes*
- Added loading feedback to form iframe


## v2.4.8
*Released on*
- 2023/05/18

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.2.1
- WooCommerce: 7.4.1 to 7.7.0

*Changes*
- Added More translations
- Added Application Version to SPG checkout request


## v2.4.9
*Released on*
- 2023/05/29

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.2.1
- WooCommerce: 7.4.1 to 7.7.0

*Changes*
- Changed label of Pay By Link Kevin to Pay By Link
- Fixed Credit Card label
- Fixed On Hold success page label


## v2.5.0
*Released on*
- 2023/07/19

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.2.1
- WooCommerce: 7.4.1 to 7.7.0

*Changes*
- Removed inputs not user
- Removed Privacy Policy warning on installation
- Updated sodium extension show


## v2.6.0
*Released on*
- 2023/10/13

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.2.1
- WooCommerce: 7.4.1 to 7.7.0

*Changes*
- Added new build, new css classes for SIBS General Settings
- Removed lost word on sibs configuration page and reformulate success message with a function
- Updated readme notes
- Fixed webhook return on error
- Added Bug Report
- Added SibsBrowser Class
- Fixed shell_exec error
- Added automatic configuration
- Fixed webhook and PHP Shell
- Returned Status Inquiry Button

## v2.7.0
*Released on*
- 2023/11/23

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.4.1
- WooCommerce: 7.4.1 to 8.3.1

*Changes*
- Added code for Xpay, but is commented as is not on production by the time of this plugin release
- Added new translations
- Removed pre-loader animated GIF

## v2.7.1
*Released on*
- 2023/11/27

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.4.1
- WooCommerce: 7.4.1 to 8.3.1

*Changes*
- Fixed checkout images size
- Fixed webhook input when use Automatic SBO
- Added availanility in languages: French, German, Italic, Romanian, Spanish

## v2.7.2
*Released on*
- 2023/12/29

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.4.2
- WooCommerce: 7.4.1 to 8.4.0

*Changes*
- Fixed checkout logos
- Fixed other translations than english, portuguese and polish
- Fixed Automatic login on SBO
- Resolved problem with calling non statically functions statically

## v2.8.0
*Released on*
- 2024/01/04

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.4.2
- WooCommerce: 7.4.1 to 8.4.0

*Changes*
- Implemented assync webhook
- Implemented blocks for some themes in chekckout

## v2.8.1
*Released on*
- 2024/01/31

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.4.3
- WooCommerce: 7.4.1 to 8.5.2

*Changes*
- Fixed blocks implementation
- Changed translation by tag key to translation by string key
- Fixed Automatic SBO on Multisite

## v2.8.2
*Released on*
- 2024/02/02

*Stability*
- PHP: 7.2 to 8.1
- WordPress: 5.9 to 6.4.3
- WooCommerce: 7.4.1 to 8.5.2

*Changes*
- Removed Unfinished XPay class

## v2.8.3
*Released on*
- 2024/02/15

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.4.3
- WooCommerce: 7.4.1 to 8.5.2

*Changes*
- New Build Version
- Resolved problem of multiple merchantTransactionID for one transactionID
- Resolved problem with reload form of a failed transaction

## v2.8.4
*Released on*
- 2024/02/19

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.4.3
- WooCommerce: 7.4.1 to 8.6.0

*Changes*
- Resolved problem to update sibs_transaction table on first install

## v2.8.5
*Released on*
- 2024/03/06

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.4.3
- WooCommerce: 7.4.1 to 8.6.1

*Changes*
- Removed CSS class that hide Product Title

## v2.8.6
*Released on*
- 2024/03/12

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.4.3
- WooCommerce: 7.4.1 to 8.6.1

*Changes*
- Added Dutch Translation

## v2.9.0
*Released on*
- 2024/03/20

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.4.3
- WooCommerce: 7.4.1 to 8.7.0

*Changes*
- Added Apple pay and Google pay
- Added new Logger to improve transaction debug
- Resolved permalink configuration problem

## v2.9.1
*Released on*
- 2024/05/03

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.5.2
- WooCommerce: 7.4.1 to 8.8.3

*Changes*
- Fixed Oneclick for blocks checkouts
- Fixed Tokenization for blocks checkouts
- Added plugin meta links
- Removed payment classes warning when add dynamically a property to a class

## v2.9.2
*Released on*
- 2024/05/15

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.5.2
- WooCommerce: 7.4.1 to 8.8.3

*Changes*
- Hotfix Oneclick for blocks checkouts
- Hotfix Tokenization for blocks checkouts

## v2.9.3
*Released on*
- 2024/05/20

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.5.2
- WooCommerce: 7.4.1 to 8.9.0

*Changes*
- Removed inquiry button on refunded orders

## v2.9.4
*Released on*
- 2024/06/20

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.5.3
- WooCommerce: 7.4.1 to 9.0.0

*Changes*
- Fixed Bug Report

## v2.9.5
*Released on*
- 2024/06/24

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.5.4
- WooCommerce: 7.4.1 to 9.0.1

*Changes*
- Security - Prevent HTML & JS injection attacks on registration and checkout forms when the Order Attribution is enabled. (woocommerce)

## v2.10.0
*Released on*
- 2024/07/04

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.5.5
- WooCommerce: 7.4.1 to 9.0.2

*Changes*
- Fixed manual and automatic backoffice CSS and JS
- Fixed code to run on databases before MySQL 5.7 version
- Fixed critical error on blocks that happens sometimes
- Added MySQL Version Information
- Added Enabled Payments Information
- Added Tables Health Information
- Added Browser Information
- Added OpenSSL Decrypt Method
- Added LibSodium Decrypt Method

## v2.10.1
*Released on*
- 2024/07/09

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.5.5
- WooCommerce: 7.4.1 to 9.0.2

*Changes*
- Fixed code to run on PHP 7.4 properly

## v2.10.2
*Released on*
- 2024/08/01

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.6.1
- WooCommerce: 7.4.1 to 9.1.4

*Changes*
- Added form language selector

## v2.10.3
*Released on*
- 2024/08/08

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.6.1
- WooCommerce: 7.4.1 to 9.1.4

*Changes*
- Fixed Address missing fields problem

## v2.10.4
*Released on*
- 2024/09/09

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.6.1
- WooCommerce: 7.4.1 to 9.2.2

*Changes*
- Fixed Default Form Language Bug

## v2.11.0
*Released on*
- 2024/09/20

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.6.1
- WooCommerce: 7.4.1 to 9.2.2

*Changes*
- Added Pay By Link Autopay
- Removed Pay By Link Kevin
  
## v2.11.1
*Released on*
- 2024/10/15

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.6.2
- WooCommerce: 7.4.1 to 9.3.3

*Changes*
- Removed mocked country and city of empty shipping and billing address

## v2.12.0
*Released on*
- 2024/10/29

*Stability*
- PHP: 7.4 to 8.2.15
- WordPress: 5.9 to 6.6.2
- WooCommerce: 7.4.1 to 9.3.3

*Changes*
- New Admin form view
- Fixed Translations
- Added build commands

## v2.12.1
*Released on*
- 2024/11/21

*Stability*
- PHP: 7.4 to 8.2.26
- WordPress: 5.9 to 6.7
- WooCommerce: 7.4.1 to 9.4.2

*Changes*
- Fixed Date to expire Pay by Link payment

## v2.13.0
*Released on*
- 2024/12/19

*Stability*
- PHP: 7.4 to 8.2.26
- WordPress: 5.9 to 6.7
- WooCommerce: 7.4.1 to 9.5.1

*Changes*
- Fixed Date Pay by Link payment
- Included note in the "MerchantId Domain Association" field

## v2.13.1
*Released on*
- 2025/03/27

*Stability*
- PHP: 7.4 to 8.2.28
- WordPress: 5.9 to 6.7
- WooCommerce: 7.4.1 to 9.7.1

*Changes*
- Fixed for wordpress 6.7

## v2.13.2
*Released on*
- 2025/04/03

*Stability*
- PHP: 7.4 to 8.2.28
- WordPress: 5.9 to 6.7
- WooCommerce: 7.4.1 to 9.7.1

*Changes*
- Added QLY mode for production version

## v2.13.3
*Released on*
- 2025/04/03

*Stability*
- PHP: 7.4 to 8.2.28
- WordPress: 5.9 to 6.7
- WooCommerce: 7.4.1 to 9.7.1

*Changes*
- Fixed timestamp for checkout

## v2.13.4
*Released on*
- 2025/04/07

*Stability*
- PHP: 7.4 to 8.2.28
- WordPress: 5.9 to 6.7
- WooCommerce: 7.4.1 to 9.7.1

*Changes*
- Updated deprecation message to use wp_date for current time display

## v2.14.0
*Released on*
- 2025/05/05

*Stability*
- PHP: 7.4 to 8.2.28
- WordPress: 5.9 to 6.8
- WooCommerce: 7.4.1 to 9.8.3

*Changes*
- Updated to work on Wordpress 6.8+ and Woocommerce 9.8.0+
- Updated transaction timestamp handling to use wp_date for consistency and add display of local hour for SIBS

## v2.14.1
*Released on*
- 2025/05/13

*Stability*
- PHP: 7.4 to 8.2.28
- WordPress: 5.9 to 6.8
- WooCommerce: 7.4.1 to 9.8.3

*Changes*
- Updated plugin to produce a small zip file

## v2.15.0
*Released on*
- 2025/05/27

*Stability*
- PHP: 7.4 to 8.2.28
- WordPress: 5.9 to 6.8
- WooCommerce: 7.4.1 to 9.8.5

*Changes*
- Changed payments images
- Improved frontend scripts
- Improved frontend styles

## v2.15.1
*Released on*
- 2025/05/28

*Stability*
- PHP: 7.4 to 8.2.28
- WordPress: 5.9 to 6.8
- WooCommerce: 7.4.1 to 9.8.5

*Changes*
- Fixed Google Pay / Apple Pay logos
- Fixed SIBS Check Status label in english

## v2.16.0
*Released on*
- 2025/07/14

*Stability*
- PHP: 7.4 to 8.2.X
- WordPress: 5.9 to 6.8.X
- WooCommerce: 7.4.1 to 10.0.X

*Changes*
- Wpdated plugin to work with Woocommerce 10.0.X

## v2.16.1
*Released on*
- 2025/11/14

*Stability*
- PHP: 7.4 to 8.3.X
- WordPress: 5.9 to 6.8.X
- WooCommerce: 7.4.1 to 10.3.X

*Changes*
- Fixed error on plugin activation

## v2.16.2
*Released on*
- 2025/12/09

*Stability*
- PHP: 7.4 to 8.3.X
- WordPress: 5.9 to 6.8.X
- WooCommerce: 7.4.1 to 10.3.X

*Changes*
- Added compatibility to WP Rocket

## v2.16.3
*Released on*
- 2025/12/10

*Stability*
- PHP: 7.4 to 8.3.X
- WordPress: 5.9 to 6.8.X
- WooCommerce: 7.4.1 to 10.3.X

*Changes*
- Updated Builder