# SSL Certificate Problem - Solução / Solution

---

## 🇵🇹 PORTUGUÊS

### Problema
Seu servidor está retornando o erro:
```
cURL error 60: SSL certificate problem: unable to get local issuer certificate
```

Este erro significa que o certificado CA (Certificate Authority) do seu servidor está **desatualizado ou não configurado corretamente**.

### ✅ Solução

O plugin SIBS já foi atualizado para usar a verificação SSL correta. Agora você precisa atualizar o certificado CA no seu servidor.

#### **Opção 1: Contatar o Suporte da Hosting** (RECOMENDADO)

Envie um ticket para o suporte da sua hosting com a seguinte mensagem:

> **Assunto**: Atualizar CA Bundle / OpenSSL Certificates
>
> **Mensagem**:
> - Estou recebendo erro `cURL error 60: SSL certificate problem: unable to get local issuer certificate`
> - Meu servidor usa LiteSpeed e PHP 7.4.33 com OpenSSL 3.2.2
> - Preciso atualizar o bundle de certificados CA no servidor
> - Por favor, atualizar `/etc/ssl/certs/ca-certificates.crt` ou equivalente
> - Ou adicionar configuração em `php.ini`: `openssl.cafile=/etc/ssl/certs/ca-certificates.crt`

#### **Opção 2: Atualizar Manualmente via SSH**

Se você tem acesso SSH ao servidor:

```bash
# 1. Conectar via SSH
ssh seu_usuario@seu_servidor.com

# 2. Fazer download dos certificados CA atualizados
sudo curl https://curl.se/ca/cacert.pem -o /etc/ssl/certs/cacert.pem

# 3. Atualizar permissões
sudo chmod 644 /etc/ssl/certs/cacert.pem

# 4. Configurar no PHP (editar /etc/php.ini ou /etc/php/7.4/apache2/php.ini)
sudo nano /etc/php.ini

# Adicionar ou descomentar a linha:
# openssl.cafile=/etc/ssl/certs/cacert.pem

# 5. Reiniciar PHP/Apache
sudo systemctl restart apache2
# ou
sudo systemctl restart php-fpm
```

#### **Opção 3: Testar a Conectividade**

Para confirmar se é um problema do servidor, execute:

```bash
# Via SSH no servidor
curl -v https://api.sibsgateway.com/api/v1/payments

# Se aparecer "SSL certificate problem", confirma que é do servidor
```

### 📋 Informações do Seu Sistema

Baseado no Status Report:
- **Server**: LiteSpeed
- **PHP Version**: 7.4.33
- **cURL Version**: 8.14.1
- **OpenSSL**: 3.2.2
- **Hosting**: Consulte seu painel de controle para detalhes

### ✔️ Confirmação

Após fazer uma das opções acima, o erro desaparecerá e os pagamentos funcionarão normalmente.

---

## 🇬🇧 ENGLISH

### Problem
Your server is returning the error:
```
cURL error 60: SSL certificate problem: unable to get local issuer certificate
```

This error means your server's CA (Certificate Authority) certificate is **outdated or not configured correctly**.

### ✅ Solution

The SIBS plugin has already been updated to use correct SSL verification. Now you need to update the CA certificate on your server.

#### **Option 1: Contact Your Hosting Support** (RECOMMENDED)

Send a support ticket to your hosting provider with the following message:

> **Subject**: Update CA Bundle / OpenSSL Certificates
>
> **Message**:
> - I am receiving the error `cURL error 60: SSL certificate problem: unable to get local issuer certificate`
> - My server uses LiteSpeed with PHP 7.4.33 and OpenSSL 3.2.2
> - I need to update the CA certificate bundle on the server
> - Please update `/etc/ssl/certs/ca-certificates.crt` or equivalent
> - Or add configuration to `php.ini`: `openssl.cafile=/etc/ssl/certs/ca-certificates.crt`

#### **Option 2: Update Manually via SSH**

If you have SSH access to your server:

```bash
# 1. Connect via SSH
ssh your_user@your_server.com

# 2. Download the latest CA certificates
sudo curl https://curl.se/ca/cacert.pem -o /etc/ssl/certs/cacert.pem

# 3. Update permissions
sudo chmod 644 /etc/ssl/certs/cacert.pem

# 4. Configure in PHP (edit /etc/php.ini or /etc/php/7.4/apache2/php.ini)
sudo nano /etc/php.ini

# Add or uncomment the line:
# openssl.cafile=/etc/ssl/certs/cacert.pem

# 5. Restart PHP/Apache
sudo systemctl restart apache2
# or
sudo systemctl restart php-fpm
```

#### **Option 3: Test Connectivity**

To confirm this is a server problem, run:

```bash
# Via SSH on the server
curl -v https://api.sibsgateway.com/api/v1/payments

# If you see "SSL certificate problem", it confirms it's a server issue
```

### 📋 Your System Information

Based on your Status Report:
- **Server**: LiteSpeed
- **PHP Version**: 7.4.33
- **cURL Version**: 8.14.1
- **OpenSSL**: 3.2.2
- **Hosting**: Check your control panel for more details

### ✔️ Confirmation

After completing one of the options above, the error will disappear and payments will work normally.

---

## 📝 Plugin Information

- **Plugin**: SIBS Payment Gateway for WooCommerce
- **Version**: 2.16.1
- **Fix Applied**: SSL verification now respects environment configuration
- **Status**: ✅ Ready for Production

For questions, contact your plugin support team.

