<?php

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ALL);

require_once explode('wp-content', __FILE__)[0] . 'wp-load.php';
require_once __DIR__ . '/vendor/autoload.php';

use Automattic\Jetpack\Constants;
use Sibs2\sibsConstants;
use Sibs2\sibsLogger;
use Sibs2\sibsSBO;

defined('ABSPATH') || exit;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $headers = getallheaders();
    $content = $_POST;

    $result  = 'NO METHOD CHOOSED';
    $sibsSBO = new sibsSBO($headers, [
        'deviceID'   => $_POST['deviceID'] ?? null,
        'serverMode' => $_POST['serverMode'] ?? null,
        'login'      => $_POST['login'] ?? null,
        'pass'       => $_POST['pass'] ?? null,
        'code'       => $_POST['code'] ?? null,
        'TermnlCd'   => $_POST['TermnlCd'] ?? null,
        'AccptrCd'   => $_POST['AccptrCd'] ?? null,
        'MrchntCd'   => $_POST['MrchntCd'] ?? null,
    ]);

    switch($_POST['action']) {
        case 'LoginSBO':
            $result = $sibsSBO->loginSBO();

            break;
        case 'ActivateSMSCode':
            $result = $sibsSBO->activateSMSCode();

            break;
        case 'ResendSMSCode':
            $result = $sibsSBO->resendSMSCode();

            break;
        case 'TerminalList':
            $result = $sibsSBO->getTerminalList();

            break;
        case 'WebhooksList':
            $result = $sibsSBO->getWebhookList();

            break;
    }

    sibsLogger::debug($_POST['action'] . ': ' . sibsLogger::prettify($result), sibsConstants::SIBS_API_LOG);
    echo $result;
} else {
    //echo 'METHOD NOT ALLOWED';
}

if (isset($_GET['info'])) {
    global $wpdb;

    try {
        $report             = wc()->api->get_endpoint_data('/wc/v3/system_status');
        $plugin_updates     = new WC_Plugin_Updates();
        $untested_plugins   = $plugin_updates->get_untested_plugins(WC()->version, Constants::get_constant('WC_SSR_PLUGIN_UPDATE_RELEASE_VERSION_TYPE'));
        echo '<pre>';

        die(json_encode($report));
    } catch (Exception $e) {
    }
}
