(function($) {
    'use strict';
    jQuery('.add-items').on('click', '.sibs-button', function() {
        var element = "#woocommerce-order-items .inside";
        // get the order_id from the button tag
        var order_id = jQuery(this).data('order_id');
        // get the product_id from the button tag
        var button_id = jQuery(this).data('button_id');
        // get the amount to be captured
        var total_amount = jQuery('input[data-scenario=amount]').val();
        // confirmation message
        var message = __("Are you sure you wish to process this action? This action cannot be undone", SIBS_TRANSLATE);
        // confirmation dialog
        var answer = window.confirm(message);

        if (answer) {
            // send the data via ajax to the sever
            jQuery(element).block({
                message: null,
                overlayCSS: {
                    cursor: 'wait',
                    background: '#fff',
                    opacity: 0.6
                }
            });

            $.ajax({
                type: 'POST',
                url: mb_script_var.ajaxurl,
                dataType: 'json',
                data: {
                    action: 'add_button_to_order_admin',
                    order_id: order_id,
                    button_id: button_id,
                    amount_id: total_amount
                },
                success: function(data, textStatus, XMLHttpRequest) {
                    // show the control message
                    alert(data.msg);
                    jQuery(element).unblock();
                    if (data.error == 0) {
                        location.href = location.href; // Refresh the page
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    alert(errorThrown);
                    jQuery(element).unblock();
                }
            });
        }
    });

    jQuery('.colorpick').iris({
        defaultColor: true,
        change: function(event, ui) {},
        clear: function() {},
        hide: true,
        palettes: true
    });

    $('.colorpick').click(function(event) {
        $('.colorpick').iris('hide');
        $(this).iris('show');
        return false;
    });

    function popOff() {
        document.body.addEventListener('click', function(event) {
            if (!jQuery(event.target).is(".colorpick, .iris-picker, .iris-picker-inner")) {
                jQuery('.colorpick').iris('hide');
                return false;
            }
        })
    }
    popOff()
})(jQuery);