import { getSetting } from "@woocommerce/settings";
import { decodeEntities } from "@wordpress/html-entities";
import { __ } from "@wordpress/i18n";
import { registerPaymentMethod } from "@woocommerce/blocks-registry";

const pblMethod = 'sibs_stg_pbl';
const pblData = getSetting(pblMethod + '_data', null);

const Label = () => {
	let title = decodeEntities(pblData?.title ?? '');
	const logos = pblData?.logos;
	const images = [];

	logos.forEach((url) => {
		images.push(
			<img
				src={url}
				style={{ display: "inline", paddingRight: "5px" }}
			/>,
		);
	});

	return (
		<div className="wc-block-components-payment-method-label wc-block-components-payment-method-label--with-icon">
			{" "}
			{images} <span> {title} </span>
		</div>
	);
};

const Content = () => {
	let description = decodeEntities(pblData?.description ?? "");

	return (
		<span>{description}</span>
	);
};

registerPaymentMethod({
	name: pblMethod,
	label: <Label />,
	ariaLabel: __("SIBS payment method", "sibs-woo-stg"),
	canMakePayment: () => true,
	content: <Content />,
	edit: <Content />,
	supports: {
		features: pblData?.supports ?? [],
	},
});
