import { getSetting } from "@woocommerce/settings";
import { decodeEntities } from "@wordpress/html-entities";
import { __ } from "@wordpress/i18n";
import { registerPaymentMethod } from "@woocommerce/blocks-registry";

const pblkvMethod = 'sibs_stg_pblkv';
const pblkvData = getSetting(pblkvMethod + '_data', null);

const Label = () => {
	let title = decodeEntities(pblkvData?.title ?? '');
	const logos = pblkvData?.logos;
	const images = [];

	logos.forEach((url) => {
		images.push(
			<img
				src={url}
				style={{ display: "inline", paddingRight: "5px" }}
			/>,
		);
	});

	return (
		<div className="wc-block-components-payment-method-label wc-block-components-payment-method-label--with-icon">
			{" "}
			{images} <span> {title} </span>
		</div>
	);
};

const Content = () => {
	let description = decodeEntities(pblkvData?.description ?? "");

	return (
		<span>{description}</span>
	);
};

registerPaymentMethod({
	name: pblkvMethod,
	label: <Label />,
	ariaLabel: __("SIBS payment method", "sibs-woo-stg"),
	canMakePayment: () => true,
	content: <Content />,
	edit: <Content />,
	supports: {
		features: pblkvData?.supports ?? [],
	},
});
