<?php

/**
 * Email Styles.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/email-styles.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @version 4.0.0
 */
defined( 'ABSPATH' ) || exit;

// Load colors.
$bg        = Sibs2\sibsConfig::getWoocommerceOption('woocommerce_email_background_color');
$body      = Sibs2\sibsConfig::getWoocommerceOption('woocommerce_email_body_background_color');
$base      = Sibs2\sibsConfig::getWoocommerceOption('woocommerce_email_base_color');
$base_text = wc_light_or_dark($base, '#202020', '#ffffff');
$text      = Sibs2\sibsConfig::getWoocommerceOption('woocommerce_email_text_color');

// Pick a contrasting color for links.
$link_color = wc_hex_is_light($base) ? $base : $base_text;

if (wc_hex_is_light($body)) {
    $link_color = wc_hex_is_light($base) ? $base_text : $base;
}

$bg_darker_10    = wc_hex_darker($bg, 10);
$body_darker_10  = wc_hex_darker($body, 10);
$base_lighter_20 = wc_hex_lighter($base, 20);
$base_lighter_40 = wc_hex_lighter($base, 40);
$text_lighter_20 = wc_hex_lighter($text, 20);
$text_lighter_40 = wc_hex_lighter($text, 40);

// !important; is a gmail hack to prevent styles being stripped if it doesn't like something.
// body{padding: 0;} ensures proper scale/positioning of the email in the iOS native email app.
?>
<style>
body {
    padding: 0;
    font-family: Helvetica, Trebuchet, Verdana;
}

#wrapper {
    background-color: <?= esc_attr($bg) ?>;
    margin: 0;
    padding: 70px 0;
    -webkit-text-size-adjust: none !important;
    width: 100%;
}

#template_container {
    box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1) !important;
    background-color: <?= esc_attr($body) ?>;
    border: 1px solid <?= esc_attr($bg_darker_10) ?>;
    border-radius: 3px !important;
}

#template_header {
    background-color: <?= esc_attr($base) ?>;
    border-radius: 3px 3px 0 0 !important;
    color: <?= esc_attr($base_text) ?>;
    border-bottom: 0;
    font-weight: bold;
    line-height: 100%;
    vertical-align: middle;
}

#template_header h1,
#template_header h1 a {
    color: <?= esc_attr($base_text) ?>;
}

#template_header_image img {
    margin-left: 0;
    margin-right: 0;
    width: 600px;
}

#template_footer td {
    padding: 0;
    border-bottom-right-radius: 6px;
    border-bottom-left-radius: 6px;
    background-color: #000000;
    color: #ffffff;
}

#template_footer #credit {
    border: 0;
    color: <?= esc_attr($text_lighter_40) ?>;
    font-size: 12px;
    line-height: 150%;
    text-align: center;
    padding: 24px 0;
}

#template_footer #credit p {
    margin: 0 0 16px;
}

#body_content {
    background-color: <?= esc_attr($body) ?>;
}

#body_content table td {
    padding: 48px 48px 32px;
}

#body_content table td td {
    padding: 12px;
}

#body_content table td th {
    padding: 12px;
}

#body_content td ul.wc-item-meta {
    font-size: small;
    margin: 1em 0 0;
    padding: 0;
    list-style: none;
}

#body_content td ul.wc-item-meta li {
    margin: 0.5em 0 0;
    padding: 0;
}

#body_content td ul.wc-item-meta li p {
    margin: 0;
}

#body_content p {
    margin: 0 0 16px;
}

#body_content_inner {
    color: <?= esc_attr($text_lighter_20) ?>;
    font-size: 14px;
    line-height: 150%;
    text-align: <?= is_rtl() ? 'right' : 'left' ?>;
}

.td {
    color: <?= esc_attr($text_lighter_20) ?>;
    border: 0px solid <?= esc_attr($body_darker_10) ?>;
    vertical-align: middle;
}

.address {
    padding: 12px;
    color: <?= esc_attr($text_lighter_20) ?>;
    border: 1px solid <?= esc_attr($body_darker_10) ?>;
    text-align: center;
    border-radius: 5px;
}

.text {
    color: <?= esc_attr($text) ?>;
}

.link {
    color: <?= esc_attr($base) ?>;
}

#header_wrapper {
    padding: 36px 48px;
    display: block;
}

h1 {
    color: <?= esc_attr($base) ?>;
    font-family: Verdana, Arial, sans-serif;
    font-size: 30px;
    font-weight: 300;
    line-height: 150%;
    margin: 0;
    text-align: <?= is_rtl() ? 'right' : 'left' ?>;
    text-shadow: 0 1px 0 <? esc_attr($base_lighter_20) ?>;
}

h2 {
    color: <? esc_attr($base) ?>;
    display: block;
    font-size: 18px;
    font-weight: bold;
    line-height: 130%;
    text-align: <? is_rtl() ? 'right' : 'left' ?>;
}

h3 {
    color: <? esc_attr($base) ?>;
    display: block;
    font-size: 16px;
    font-weight: bold;
    line-height: 130%;
    margin: 16px 0 8px;
    text-align: <? is_rtl() ? 'right' : 'left' ?>;
}

a {
    color: <? esc_attr($link_color) ?>;
    font-weight: normal;
    text-decoration: underline;
}

img {
    border: none;
    display: inline-block;
    font-size: 14px;
    font-weight: bold;
    height: auto;
    outline: none;
    text-decoration: none;
    text-transform: capitalize;
    vertical-align: middle;
    margin-<? is_rtl() ? 'left' : 'right' ?>: 10px;
    max-width: 100%;
    height: auto;
}

.heading_bk {
    border-radius: 5px;
    background-color: #f7f7f7;
    padding: 5px 5px;
    vertical-align: middle;
    margin-bottom: 5px;
}
table#addresses{
    border: none;
}
#template_footer_image {
    padding: 0;
    background-color: #f7f7f7;
    text-align: center;
}
#template_footer_image img {
    width: 150px;
}

.titles {
    color: #6f6f6f;
}
</style>
<?php
