<?php
defined('ABSPATH') || exit;

$blocks_enabled = get_option('sibs_blocks_enabled', 'no');
$migration_status = $this->get_migration_status();
?>

<div class="wrap">
    <h1><?php _e('SIBS Beta Features', 'sibs-woo-stg'); ?></h1>
    
    <div class="notice notice-info">
        <p><strong><?php _e('Beta Features', 'sibs-woo-stg'); ?>:</strong> 
        <?php _e('These features are experimental and should be tested thoroughly before use in production.', 'sibs-woo-stg'); ?></p>
    </div>

    <div class="sibs-beta-container">
        <div class="sibs-beta-card">
            <h2><?php _e('WooCommerce Blocks Integration', 'sibs-woo-stg'); ?></h2>
            
            <div class="sibs-migration-status">
                <h3><?php _e('Migration Status', 'sibs-woo-stg'); ?></h3>
                <table class="widefat fixed striped">
                    <thead>
                        <tr>
                            <th><?php _e('Gateway', 'sibs-woo-stg'); ?></th>
                            <th><?php _e('Classic Checkout', 'sibs-woo-stg'); ?></th>
                            <th><?php _e('Blocks Ready', 'sibs-woo-stg'); ?></th>
                            <th><?php _e('Status', 'sibs-woo-stg'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($migration_status as $gateway => $status): ?>
                        <tr>
                            <td><?php echo esc_html($status['name']); ?></td>
                            <td>
                                <span class="dashicons <?php echo $status['classic_enabled'] ? 'dashicons-yes-alt' : 'dashicons-dismiss'; ?>" 
                                      style="color: <?php echo $status['classic_enabled'] ? 'green' : 'red'; ?>;"></span>
                            </td>
                            <td>
                                <span class="dashicons <?php echo $status['blocks_ready'] ? 'dashicons-yes-alt' : 'dashicons-dismiss'; ?>" 
                                      style="color: <?php echo $status['blocks_ready'] ? 'green' : 'red'; ?>;"></span>
                            </td>
                            <td>
                                <?php if ($status['migrated']): ?>
                                    <span class="sibs-status-migrated"><?php _e('Migrated', 'sibs-woo-stg'); ?></span>
                                <?php elseif ($status['classic_enabled']): ?>
                                    <span class="sibs-status-ready"><?php _e('Ready to Migrate', 'sibs-woo-stg'); ?></span>
                                <?php else: ?>
                                    <span class="sibs-status-disabled"><?php _e('Disabled', 'sibs-woo-stg'); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="sibs-migration-actions">
                <h3><?php _e('Migration Actions', 'sibs-woo-stg'); ?></h3>
                
                <?php if ($blocks_enabled === 'no'): ?>
                    <form method="post" action="">
                        <?php wp_nonce_field('sibs_migrate_blocks', 'sibs_migrate_nonce'); ?>
                        <input type="hidden" name="migrate_to_blocks" value="1" />
                        
                        <p><?php _e('Migrate your SIBS payment gateways to support WooCommerce Checkout Blocks.', 'sibs-woo-stg'); ?></p>
                        
                        <div class="sibs-migration-warning">
                            <p><strong><?php _e('Important:', 'sibs-woo-stg'); ?></strong></p>
                            <ul>
                                <li><?php _e('This will enable blocks support for all SIBS gateways', 'sibs-woo-stg'); ?></li>
                                <li><?php _e('Your existing settings will be preserved', 'sibs-woo-stg'); ?></li>
                                <li><?php _e('Test thoroughly before using in production', 'sibs-woo-stg'); ?></li>
                                <li><?php _e('You can rollback if needed', 'sibs-woo-stg'); ?></li>
                            </ul>
                        </div>
                        
                        <p class="submit">
                            <input type="submit" class="button-primary" 
                                   value="<?php _e('Migrate to Blocks', 'sibs-woo-stg'); ?>" 
                                   onclick="return confirm('<?php _e('Are you sure you want to migrate to blocks?', 'sibs-woo-stg'); ?>')" />
                        </p>
                    </form>
                <?php else: ?>
                    <div class="sibs-blocks-enabled">
                        <p><span class="dashicons dashicons-yes-alt" style="color: green;"></span> 
                        <?php _e('Blocks support is enabled!', 'sibs-woo-stg'); ?></p>
                        
                        <p><strong><?php _e('Migration Date:', 'sibs-woo-stg'); ?></strong> 
                        <?php echo esc_html(get_option('sibs_migration_date', __('Unknown', 'sibs-woo-stg'))); ?></p>
                        
                        <form method="post" action="">
                            <?php wp_nonce_field('sibs_rollback_blocks', 'sibs_rollback_nonce'); ?>
                            <input type="hidden" name="rollback_blocks" value="1" />
                            <p class="submit">
                                <input type="submit" class="button-secondary" 
                                       value="<?php _e('Rollback to Classic', 'sibs-woo-stg'); ?>" 
                                       onclick="return confirm('<?php _e('Are you sure you want to rollback? This will disable blocks support.', 'sibs-woo-stg'); ?>')" />
                            </p>
                        </form>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="sibs-beta-card">
            <h2><?php _e('Testing Tools', 'sibs-woo-stg'); ?></h2>
            
            <div class="sibs-testing-tools">
                <h3><?php _e('Compatibility Check', 'sibs-woo-stg'); ?></h3>
                <p><?php _e('Test if your system is ready for WooCommerce Blocks integration.', 'sibs-woo-stg'); ?></p>
                
                <button type="button" class="button" id="sibs-test-blocks">
                    <?php _e('Test Blocks Compatibility', 'sibs-woo-stg'); ?>
                </button>
                
                <div id="sibs-test-results" style="display: none; margin-top: 20px;">
                    <h4><?php _e('Test Results:', 'sibs-woo-stg'); ?></h4>
                    <div id="sibs-test-output"></div>
                </div>
            </div>

            <div class="sibs-debug-info" style="margin-top: 30px;">
                <h3><?php _e('Debug Information', 'sibs-woo-stg'); ?></h3>
                <table class="widefat">
                    <tr>
                        <td><strong><?php _e('Plugin Version:', 'sibs-woo-stg'); ?></strong></td>
                        <td><?php echo defined('SIBS_VERSION') ? SIBS_VERSION : __('Unknown', 'sibs-woo-stg'); ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php _e('WordPress Version:', 'sibs-woo-stg'); ?></strong></td>
                        <td><?php echo get_bloginfo('version'); ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php _e('WooCommerce Version:', 'sibs-woo-stg'); ?></strong></td>
                        <td><?php echo defined('WC_VERSION') ? WC_VERSION : __('Not installed', 'sibs-woo-stg'); ?></td>
                    </tr>
                    <tr>
                        <td><strong><?php _e('Blocks Enabled:', 'sibs-woo-stg'); ?></strong></td>
                        <td><?php echo $blocks_enabled === 'yes' ? __('Yes', 'sibs-woo-stg') : __('No', 'sibs-woo-stg'); ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<style>
.sibs-beta-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin-top: 20px;
}

.sibs-beta-card {
    background: #fff;
    border: 1px solid #ccd0d4;
    box-shadow: 0 1px 1px rgba(0,0,0,0.04);
    padding: 20px;
    border-radius: 4px;
}

.sibs-migration-warning {
    background: #fff3cd;
    border: 1px solid #ffeaa7;
    border-radius: 4px;
    padding: 15px;
    margin: 15px 0;
    border-left: 4px solid #f39c12;
}

.sibs-migration-warning ul {
    margin: 10px 0 0 20px;
}

.sibs-status-migrated { 
    color: #46b450; 
    font-weight: bold; 
}

.sibs-status-ready { 
    color: #0073aa; 
    font-weight: bold; 
}

.sibs-status-disabled { 
    color: #a00; 
}

.sibs-blocks-enabled {
    background: #d4edda;
    border: 1px solid #c3e6cb;
    border-radius: 4px;
    padding: 15px;
    color: #155724;
    border-left: 4px solid #28a745;
}

.sibs-testing-tools {
    margin-bottom: 20px;
}

.sibs-debug-info table {
    margin-top: 10px;
}

.sibs-debug-info td {
    padding: 8px 12px;
}

@media (max-width: 768px) {
    .sibs-beta-container {
        grid-template-columns: 1fr;
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    $('#sibs-test-blocks').on('click', function() {
        var button = $(this);
        var results = $('#sibs-test-results');
        var output = $('#sibs-test-output');
        
        button.prop('disabled', true).text('<?php _e('Testing...', 'sibs-woo-stg'); ?>');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'sibs_test_blocks_compatibility',
                nonce: '<?php echo wp_create_nonce('sibs_test_blocks'); ?>'
            },
            success: function(response) {
                if (response.success) {
                    output.html(response.data);
                    results.show();
                } else {
                    output.html('<div class="notice notice-error"><p><?php _e('Test failed. Please check console for errors.', 'sibs-woo-stg'); ?></p></div>');
                    results.show();
                }
            },
            error: function() {
                output.html('<div class="notice notice-error"><p><?php _e('AJAX request failed.', 'sibs-woo-stg'); ?></p></div>');
                results.show();
            },
            complete: function() {
                button.prop('disabled', false).text('<?php _e('Test Blocks Compatibility', 'sibs-woo-stg'); ?>');
            }
        });
    });
});
</script>