<?php
defined('ABSPATH') || exit;

// Verificar se as variáveis foram passadas pela classe admin
$environment = isset($environment) ? $environment : array();
$languages = isset($languages) ? $languages : array();


//$system_info = isset($system_info) ? $system_info : array();
//$current_settings = isset($current_settings) ? $current_settings : array();
//$field_config = isset($field_config) ? $field_config : array();
//$view_data = isset($view_data) ? $view_data : array();


// Função auxiliar simplificada para obter valores
function get_setting_value($key, $current_settings, $default = '') {
    return isset($current_settings[$key]) ? $current_settings[$key] : $default;
}

// Função auxiliar para obter nome do campo
function get_field_name($field, $field_config) {
    return isset($field_config[$field]) ? $field_config[$field] : 'sibs_general_config_' . $field;
}

// Função auxiliar para webhook description
function get_webhook_description($view_data) {
    return isset($view_data['webhook_description']) ? $view_data['webhook_description'] : __('Secret key for webhook validation from SIBS', 'sibs-woo-stg');
}
?>

<div class="wrap sibs-admin-wrap">
    <!-- Header -->
    <div class="sibs-header">
        <div class="sibs-header-content">
            <div class="sibs-logo">
                <img src="<?= esc_attr(WC_GATEWAY_SIBS_URL . '/assets/images/logo.png') ?>" alt="SIBS" />
            </div>
            <div class="sibs-title">
                <h1><?= __('SIBS Payment Gateway', 'sibs-woo-stg') ?></h1>
                <p><?= __('Configure your SIBS payment methods for WooCommerce', 'sibs-woo-stg') ?></p>
            </div>
        </div>
    </div>

    <div class="sibs-admin-container">
        <!-- Main Content -->
        <div class="sibs-main-content">
            <form method="POST" action="" enctype="multipart/form-data" class="sibs-settings-form">
                <?php wp_nonce_field('sibs_save_settings', 'sibs_nonce'); ?>
                
                <!-- Terminal Settings -->
                <div class="sibs-card">
                    <div class="sibs-card-header">
                        <h2><?= __('Terminal Settings', 'sibs-woo-stg') ?></h2>
                        <p><?= __('Configure your SIBS terminal credentials', 'sibs-woo-stg') ?></p>
                    </div>
                    <div class="sibs-card-body">
                        <div class="sibs-form-group">
                            <label for="sibs_merchant_no" class="sibs-label required">
                                <?= __('Terminal Code', 'sibs-woo-stg') ?>
                            </label>
                            <input type="text" 
                                   id="sibs_merchant_no"
                                   name="<?= esc_attr(get_field_name('merchant_no', $field_config)) ?>"
                                   value="<?= esc_attr(get_setting_value('terminal_id', $current_settings)) ?>"
                                   class="sibs-input"
                                   required>
                            <p class="sibs-help-text"><?= __('Your SIBS terminal identification code', 'sibs-woo-stg') ?></p>
                        </div>

                        <div class="sibs-form-group">
                            <label for="sibs_client_id" class="sibs-label required">
                                <?= __('Client ID', 'sibs-woo-stg') ?>
                            </label>
                            <input type="text" 
                                   id="sibs_client_id"
                                   name="<?= esc_attr(get_field_name('client_id', $field_config)) ?>"
                                   value="<?= esc_attr(get_setting_value('client_id', $current_settings)) ?>"
                                   class="sibs-input"
                                   required>
                            <p class="sibs-help-text"><?= __('Your SIBS API client identifier', 'sibs-woo-stg') ?></p>
                        </div>

                        <div class="sibs-form-group">
                            <label for="sibs_bearer_token" class="sibs-label required">
                                <?= __('Bearer Token', 'sibs-woo-stg') ?>
                            </label>
                            <textarea id="sibs_bearer_token"
                                      name="<?= esc_attr(get_field_name('bearer_token', $field_config)) ?>"
                                      class="sibs-textarea"
                                      rows="5"
                                      required><?= esc_textarea(get_setting_value('bearer_token', $current_settings)) ?></textarea>
                            <p class="sibs-help-text"><?= __('Your SIBS API authentication token', 'sibs-woo-stg') ?></p>
                        </div>

                        <div class="sibs-form-group">
                            <label for="sibs_environment" class="sibs-label">
                                <?= __('Environment', 'sibs-woo-stg') ?>
                            </label>
                            <select id="sibs_environment"
                                    name="<?= esc_attr(get_field_name('environment', $field_config)) ?>"
                                    class="sibs-select">
                                <?php if (!empty($environment)): ?>
                                    <?php foreach ($environment as $key => $value): ?>
                                        <option value="<?= esc_attr($key) ?>" 
                                                <?= selected($key, get_setting_value('environment', $current_settings, 'sandbox')) ?>>
                                            <?= esc_html($value) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <option value="sandbox" <?= selected('sandbox', get_setting_value('environment', $current_settings, 'sandbox')) ?>>
                                        <?= __('Sandbox', 'sibs-woo-stg') ?>
                                    </option>
                                    <option value="production" <?= selected('production', get_setting_value('environment', $current_settings, 'sandbox')) ?>>
                                        <?= __('Production', 'sibs-woo-stg') ?>
                                    </option>
                                <?php endif; ?>
                            </select>
                            <p class="sibs-help-text"><?= __('Select the appropriate SIBS environment', 'sibs-woo-stg') ?></p>
                        </div>
                        
<!-- forceDisableClickToPay -->
<div class="sibs-form-group">
    <label for="sibs_force_disable_click_to_pay" class="sibs-label">
        <?= __('Force Disable Click to Pay', 'sibs-woo-stg') ?>
    </label>
    <select id="sibs_force_disable_click_to_pay"
            name="<?= esc_attr(get_field_name('force_disable_click_to_pay', $field_config)) ?>"
            class="sibs-select">
        <option value="0" <?= selected(get_setting_value('force_disable_click_to_pay', $current_settings, '0'), '0') ?>>
            <?= __('No', 'sibs-woo-stg') ?>
        </option>
        <option value="1" <?= selected(get_setting_value('force_disable_click_to_pay', $current_settings, '0'), '1') ?>>
            <?= __('Yes', 'sibs-woo-stg') ?>
        </option>
    </select>
    <p class="sibs-help-text"><?= __('If enabled, Click to Pay will be forcibly disabled for this terminal.', 'sibs-woo-stg') ?></p>
</div>

                        <div class="sibs-form-group">
                            <label for="sibs_webhook_secret" class="sibs-label">
                                <?= __('Webhook Secret', 'sibs-woo-stg') ?>
                            </label>
                            <input type="text" 
                                   id="sibs_webhook_secret"
                                   name="<?= esc_attr(get_field_name('webhook_secret', $field_config)) ?>"
                                   value="<?= esc_attr(get_setting_value('webhook_secret', $current_settings)) ?>"
                                   class="sibs-input">
                            <p class="sibs-help-text">
                                <?= get_webhook_description($view_data) ?>
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Form Settings -->
                <div class="sibs-card">
                    <div class="sibs-card-header">
                        <h2><?= __('Form Settings', 'sibs-woo-stg') ?></h2>
                        <p><?= __('Configure the payment form language and appearance', 'sibs-woo-stg') ?></p>
                    </div>
                    <div class="sibs-card-body">
                        <div class="sibs-form-group">
                            <label for="sibs_language" class="sibs-label">
                                <?= __('Form Language', 'sibs-woo-stg') ?>
                            </label>
                            <select id="sibs_language"
                                    name="<?= esc_attr(get_field_name('language', $field_config)) ?>"
                                    class="sibs-select">
                                <?php if (!empty($languages)): ?>
                                    <?php foreach ($languages as $key => $value): ?>
                                        <option value="<?= esc_attr($key) ?>" 
                                                <?= selected($key, get_setting_value('language', $current_settings, 'pt')) ?>>
                                            <?= esc_html($value) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <option value="pt" <?= selected('pt', get_setting_value('language', $current_settings, 'pt')) ?>>
                                        <?= __('Portuguese', 'sibs-woo-stg') ?>
                                    </option>
                                    <option value="en" <?= selected('en', get_setting_value('language', $current_settings, 'pt')) ?>>
                                        <?= __('English', 'sibs-woo-stg') ?>
                                    </option>
                                <?php endif; ?>
                            </select>
                            <p class="sibs-help-text"><?= __('Language for the payment forms', 'sibs-woo-stg') ?></p>
                        </div>
                    </div>
                </div>

                <!-- Apple Pay Settings -->
                <div class="sibs-card">
                    <div class="sibs-card-header">
                        <h2><?= __('Apple Pay Settings', 'sibs-woo-stg') ?></h2>
                        <p>
                            <?= __('Configure Apple Pay domain verification.', 'sibs-woo-stg') ?>
                            <a href="https://www.docs.pay.sibs.com/payment-methods/apple-pay/" target="_blank">
                                <?= __('View documentation', 'sibs-woo-stg') ?>
                            </a>
                        </p>
                    </div>
                    <div class="sibs-card-body">
                        <div class="sibs-form-group">
                            <label for="sibs_merchant_domain_association" class="sibs-label">
                                <?= __('Domain Association File', 'sibs-woo-stg') ?>
                            </label>
                            <input type="file" 
                                   id="sibs_merchant_domain_association"
                                   name="<?= esc_attr(get_field_name('merchant_domain_association', $field_config)) ?>"
                                   class="sibs-file-input"
                                   accept=".txt,.pem">
                            <p class="sibs-help-text">
                                <?= __('Upload the domain association file provided by Apple for Apple Pay verification.', 'sibs-woo-stg') ?>
                            </p>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                <div class="sibs-actions">
                    <button type="submit" name="sibs_save" class="sibs-button sibs-button-primary">
                        <span class="dashicons dashicons-yes"></span>
                        <?= __('Save Settings', 'sibs-woo-stg') ?>
                    </button>
                    
                    <a href="<?= admin_url('admin.php?page=sibs-beta') ?>" class="sibs-button sibs-button-secondary">
                        <span class="dashicons dashicons-admin-tools"></span>
                        <?= __('Beta Features', 'sibs-woo-stg') ?>
                    </a>
                </div>
            </form>
        </div>

        <!-- Sidebar -->
        <div class="sibs-sidebar">
            <?php if (!empty($system_info)): ?>
                <?php foreach ($system_info as $info): ?>
                    <div class="sibs-info-card">
                        <h3><?= esc_html($info['title']) ?></h3>
                        <div class="sibs-info-content">
                            <?= $info['content'] ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="sibs-info-card">
                    <h3><?= __('Plugin Information', 'sibs-woo-stg') ?></h3>
                    <div class="sibs-info-content">
                        <strong><?= __('Version:', 'sibs-woo-stg') ?></strong> <?= defined('SIBS_VERSION') ? SIBS_VERSION : __('Unknown', 'sibs-woo-stg') ?><br>
                        <strong><?= __('Status:', 'sibs-woo-stg') ?></strong> <?= __('Active', 'sibs-woo-stg') ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Quick Actions -->
            <div class="sibs-info-card">
                <h3><?= __('Quick Actions', 'sibs-woo-stg') ?></h3>
                <div class="sibs-quick-actions">
                    <a href="<?= admin_url('admin.php?page=wc-settings&tab=checkout') ?>" class="sibs-quick-link">
                        <span class="dashicons dashicons-admin-settings"></span>
                        <?= __('Payment Methods', 'sibs-woo-stg') ?>
                    </a>
                    <a href="<?= admin_url('admin.php?page=sibs-beta') ?>" class="sibs-quick-link">
                        <span class="dashicons dashicons-admin-tools"></span>
                        <?= __('Beta Features', 'sibs-woo-stg') ?>
                    </a>
                    <a href="https://www.docs.pay.sibs.com/" target="_blank" class="sibs-quick-link">
                        <span class="dashicons dashicons-external"></span>
                        <?= __('Documentation', 'sibs-woo-stg') ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Form validation and submission handling
    $('.sibs-settings-form').on('submit', function(e) {
        const $submitBtn = $(this).find('button[type="submit"]');
        const originalText = $submitBtn.html();
        
        $submitBtn.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span> <?= esc_js(__('Saving...', 'sibs-woo-stg')) ?>');
        
        setTimeout(function() {
            $submitBtn.prop('disabled', false).html(originalText);
        }, 2000);
    });
    
    // File input handling
    $('.sibs-file-input').on('change', function() {
        const fileName = $(this).val().split('\\').pop();
        const $helpText = $(this).siblings('.sibs-help-text');
        
        $helpText.find('.file-selected').remove();
        
        if (fileName) {
            $helpText.prepend('<strong class="file-selected" style="color: #28a745;"><?= esc_js(__('Selected file:', 'sibs-woo-stg')) ?> ' + fileName + '</strong><br>');
        }
    });
});
</script>