<?php

use Sibs2\sibsConfig;
use Sibs2\sibsConstants;
use Sibs2\sibsLogger;
use Sibs2\sibsPaymentGateway;

defined('ABSPATH') || exit;

class Gateway_Sibs_STG_CC extends sibsPaymentGateway
{
    /**
     * @var string
     */
    public $id    = sibsConstants::SIBS_PAYMENT_METHOD_ORDER_CREDIT_CARD;

    /**
     * @var string
     */
    public $title = 'Cards';

    /**
     * Constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->title = __('Card', sibsConstants::SIBS_TRANSLATE);
        $this->icon  = "{$this->plugins_url}/assets/images/cc.svg";
    }

    /**
     * SIBS: Get Multi Icon
     *
     * @return string
     */
    public function get_multi_icon()
    {
        $icons_html = '';

        $payment_setting = sibsConfig::getPaymentOption($this->payment_id);
        $cards           = $payment_setting['card_types'];

        if (!empty($cards)) {
            foreach ($cards as $card) {
                $method = strtolower($card);
                $icon = $this->plugins_url . "/assets/images/{$method}.svg";
                $icons_html .= "<img src=\"$icon\" alt=\"$method\" title=\"$method\" 
                    style=\"height:40px; max-height:40px; margin:5px 10px 5px 0; float: none; vertical-align: middle; display: inline;\" />";
            }
        } else {
            $icons_html = "<img src=\"$this->icon\" alt=\"$this->title\" title=\"$this->title\"
                style=\"height:40px; max-height:40px; margin:5px 10px 5px 0; float: none; vertical-align: middle; display: inline;\" />";
        }

        return $icons_html;
    }

    /**
     * Thank You Page
     *
     * @param int $order_id
     * @return void
     */
    public function sibs_thankyou_page($order_id)
    {
        try {
            sibsLogger::debug('Thank You Payment Order Id: ' . $order_id, sibsConstants::SIBS_LOG);

            if (empty($order_id)) {
                throw new Exception('[sibs_thankyou_page] Order Id not Found');
            }

            $order            = wc_get_order($order_id);
            $payment_method   = $order->get_payment_method();
            $payment_status   = $order->get_status();

            if ($payment_method !== sibsConstants::SIBS_PAYMENT_METHOD_ORDER_CREDIT_CARD) {
                throw new Exception('[sibs_thankyou_page] Payment Method not Card');
            }

            ?>
                <section class="woocommerce-order-details sibs-payment-details-wrapper">
                    <h2 class="sibs-payment-details__title">
                        <?= $this->get_multi_icon() ?>
                        <?= esc_html(__('Card', sibsConstants::SIBS_TRANSLATE)) ?>
                    </h2>

                    <p class="sibs-payment-details__notice">
                        <?= 
                            ($payment_status != sibsConstants::ORDER_STATUS_PROCESSING) ?
                            esc_html(__('Your Card payment is pending. You will receive an e-mail when your payment status changes.', sibsConstants::SIBS_TRANSLATE)) :
                            esc_html(__('The payment was finalized using Card.', sibsConstants::SIBS_TRANSLATE))
                        ?>
                    </p>
                </section>
            <?php
        } catch (Exception $e) {
            sibsLogger::error($e->getMessage(), sibsConstants::SIBS_LOG);

            ?>
                <ul class="sibs-payment-error">
                    <li>
                        <?= esc_attr(__('Card Error.', sibsConstants::SIBS_TRANSLATE)) ?>:
                        <strong><?= esc_attr(__('Could not retrieve data from Card.', sibsConstants::SIBS_TRANSLATE)) ?></strong>
                    </li>
                </ul>
            <?php
        }
    }

    /**
     * Needs Setup.
     *
     * @return bool
     */
    public function needs_setup()
    {
        return false;
    }
}

$obj = new Gateway_Sibs_STG_CC();
