<?php

use Sibs2\sibsConstants;
use Sibs2\sibsLogger;
use Sibs2\sibsPaymentGateway;

defined('ABSPATH') || exit;

class Gateway_Sibs_STG_Pbl extends sibsPaymentGateway
{
    /**
     * @var string
     */
    public $id    = sibsConstants::SIBS_PAYMENT_METHOD_ORDER_PAY_BY_LINK;

    /**
     * @var string
     */
    public $title = 'Pay by Link';

    /**
     * Constructor.
     */
    public function __construct()
    {
        parent::__construct();
        $this->title = __('Pay by Link', sibsConstants::SIBS_TRANSLATE);
        $this->icon  = "{$this->plugins_url}/assets/images/pbl.svg";
    }

    /**
     * Get Multi Icon
     *
     * @return string
     */
    public function get_multi_icon()
    {
        $icon_html = "<img src=\"$this->icon\" alt=\"$this->title\" title=\"$this->title\"
                style=\"height:40px; max-height:40px; margin:5px 10px 5px 0; float: none; vertical-align: middle; display: inline;\" />";

        return $icon_html;
    }

    /**
     * Thank You Page
     *
     * @param int $order_id
     * @return void
     */
    public function sibs_thankyou_page($order_id)
    {
        try {
            sibsLogger::debug('Thank You Payment Order Id: ' . $order_id, sibsConstants::SIBS_LOG);

            if (empty($order_id)) {
                throw new Exception('[sibs_thankyou_page] Order Id not Found');
            }

            $order            = wc_get_order($order_id);
            $payment_method   = $order->get_payment_method();
            $payment_status   = $order->get_status();

            if ($payment_method !== sibsConstants::SIBS_PAYMENT_METHOD_ORDER_PAY_BY_LINK) {
                throw new Exception('[sibs_thankyou_page] Payment Method not Pay by Link');
            }

            ?>
                <section class="woocommerce-order-details sibs-payment-details-wrapper">
                    <h2 class="sibs-payment-details__title">
                        <?= $this->get_multi_icon() ?>
                        <?= esc_html(__('Pay by Link', sibsConstants::SIBS_TRANSLATE)) ?>
                    </h2>

                    <p class="sibs-payment-details__notice">
                        <?= 
                            ($payment_status != sibsConstants::ORDER_STATUS_PROCESSING) ?
                            esc_html(__('Your Pay by Link payment is pending. You will receive an e-mail when your payment status changes.', sibsConstants::SIBS_TRANSLATE)) :
                            esc_html(__('The payment was finalized using Pay by Link.', sibsConstants::SIBS_TRANSLATE))
                        ?>
                    </p>
                </section>
            <?php
        } catch (Exception $e) {
            sibsLogger::error($e->getMessage(), sibsConstants::SIBS_LOG);

            ?>
                <ul class="sibs-payment-error">
                    <li>
                        <?= esc_attr(__('Pay by Link Error.', sibsConstants::SIBS_TRANSLATE)) ?>:
                        <strong><?= esc_attr(__('Could not retrieve data from Pay by Link.', sibsConstants::SIBS_TRANSLATE)) ?></strong>
                    </li>
                </ul>
            <?php
        }
    }

    /**
     * Needs Setup.
     *
     * @return bool
     */
    public function needs_setup()
    {
        return false;
    }
}

$obj = new Gateway_Sibs_STG_Pbl();
