<?php
/**
* sibs Admin Page.
*/
require_once plugin_dir_path(realpath(__DIR__ . '/')) . '/vendor/autoload.php';

use Sibs2\sibsConfig;
use Sibs2\sibsConstants;
use Sibs2\sibsPayments;

function sibs_admin_style_menu()
{
    add_submenu_page(
        'woocommerce',
        __('SIBS Style', sibsConstants::SIBS_TRANSLATE),
        __('SIBS Style', sibsConstants::SIBS_TRANSLATE),
        'manage_options',
        'sibs_style',
        'sibs_page_style_content',
        3
    );
}

//add_action('admin_menu', 'sibs_admin_style_menu');

function sibs_page_style_content()
{
    if (isset($_POST['sibs_save_style_settings'])) {
        sibsPayments::saveDataStyleSettings($_POST);
    }

    wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('iris', admin_url('js/iris.min.js'), [], false, 1);

    $layout = [
        'default'   => __('default', sibsConstants::SIBS_TRANSLATE),
        'list'      => __('list', sibsConstants::SIBS_TRANSLATE),
        'accordion' => __('accordion', sibsConstants::SIBS_TRANSLATE),
    ];
    $style_theme = [
        'default' => __('default', sibsConstants::SIBS_TRANSLATE),
        'light'   => __('light', sibsConstants::SIBS_TRANSLATE),
        'gray'    => __('gray', sibsConstants::SIBS_TRANSLATE),
        'dark'    => __('dark', sibsConstants::SIBS_TRANSLATE),
    ];
    ?>

<style type="text/css">
	.iris-picker {
		z-index: 100;
		display: none;
		position: absolute;
		border: 1px solid #ccc;
		border-radius: 3px;
		box-shadow: 0 1px 3px rgb(0 0 0 / 20%);
	}
</style>

	<div class="sibs_header">
		<div>
			<img src="<?= esc_attr(plugins_url(sibsConstants::SIBS_TRANSLATE . '/assets/images/logo.png', )) ?>" alt="Sibs">
		</div>
		<div>
			<h1><?= __('SIBS Style', sibsConstants::SIBS_TRANSLATE) ?></h1>
		</div>
	</div>
	<?php if (isset($_POST['sibs_save_style_settings'])) { ?>
		<div class="sibs-notice notice notice-success"> 
			<p>
				<strong><?= __('Settings saved', sibsConstants::SIBS_TRANSLATE) ?></strong>
			</p>
		</div>
	<?php } ?>

	<div class="sibs-settings">
		<form name="sibs-settings" method="POST" action="" style="width: 90%;"> 
			<table class="form-table" role="presentation">
				<tbody>
					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout' ?>">
								<?= __('Layout', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<select name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout' ?>" style="width:25em;">
								<?php
                                    foreach ($layout as $key => $value) {
                                        if (sibsConfig::getStyleOption('layout') == $key) {
                                            ?>
												<option value="<?= $key ?>" selected><?= $value ?></option>
											<?php
                                        } else {
                                            ?>
												<option value="<?= $key ?>" ><?= $value ?></option>
											<?php
                                        }
                                    }
    							?>
							</select>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout_primary' ?>">
								<?php __('Button Color', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<input class="regular-text colorpick" type="text"
								name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout_primary' ?>"
								value="<?= __(sibsConfig::getStyleOption('layout_primary')) ?>" />
							</p>
						</td>
					</tr>

					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout_surface'?>">
								<?= __('Surface Color', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<input class="regular-text colorpick" type="text"
								name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout_surface'?>"
								value="<?= __(sibsConfig::getStyleOption('layout_surface')) ?>" />
							</p>
						</td>
					</tr>

					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout_text_color' ?>">
								<?= __('Text Color', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<input class="regular-text colorpick" type="text"
								name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout_text_color'?>"
								value="<?= __(sibsConfig::getStyleOption('layout_text_color')) ?>" />
							</p>
						</td>
					</tr>

					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout_header_color'?>">
								<?= __('Header Color', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<input class="regular-text colorpick" type="text"
								name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_layout_header_color'?>"
								value="<?= __(sibsConfig::getStyleOption('layout_header_color')) ?>" />
							</p>
						</td>
					</tr>

					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme' ?>">
								<?= __('Theme', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<select name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme'?>" style="width:25em;">
								<?php
        foreach ($style_theme as $key => $value) {
            if (sibsConfig::getStyleOption('theme') == $key) {
                ?>
												<option value="<?= $key ?>" selected><?= $value ?></option>
											<?php
            } else {
                ?>
												<option value="<?= $key ?>" ><?= $value ?></option>
											<?php
            }
        }
    ?>
							</select>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme_secondary_color' ?>">
								<?= __('Secondary', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<input class="regular-text colorpick" type="text"
								name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme_secondary_color' ?>"
								value="<?= __(sibsConfig::getStyleOption('theme_secondary_color')) ?>" />
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme_background_color' ?>">
								<?= __('Background', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<input class="regular-text colorpick" type="text"
								name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme_background_color' ?>"
								value="<?= __(sibsConfig::getStyleOption('theme_background_color')) ?>" />
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme_border_color' ?>">
								<?= __('Border', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<input class="regular-text colorpick" type="text"
								name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme_border_color' ?>"
								value="<?= __(sibsConfig::getStyleOption('theme_border_color')) ?>" />
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme_header_text' ?>">
								<?= __('Header Text', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<input class="regular-text colorpick" type="text"
								name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_theme_header_text' ?>"
								value="<?= __(sibsConfig::getStyleOption('theme_header_text')) ?>" />
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="<?= sibsConfig::SIBS_STYLE_CONFIG . '_font' ?>">
								<?= __('Font Family', sibsConstants::SIBS_TRANSLATE) ?>
							</label>
						</th>
						<td>
							<input class="regular-text" type="text"
								name="<?= sibsConfig::SIBS_STYLE_CONFIG . '_font'?>"
								value="<?= __(sibsConfig::getStyleOption('font')) ?>" >
						</td>
					</tr>
				</tbody>
			</table>			
			<p>
				<input class="button button-primary" type="submit"
					name="sibs_save_style_settings"
					value="<?= __('Save Changes', sibsConstants::SIBS_TRANSLATE) ?>">
			</p>
		</form>
	</div>
<?php
}

?>