<?php

/**
 * Sibs Plugin Additional.
 *
 * This file is used for add payment status, extra customer info.
 * Copyright (c) SIBS
 *
 * @located at  /
 */
require_once __DIR__ . '/vendor/autoload.php';

use Sibs2\sibsConstants;

defined('ABSPATH') || exit;

add_action('wp_print_scripts', 'sibs_add_custom_order_status_icon');
add_action('woocommerce_checkout_process', 'verify_billing_shipping_address');

add_filter('init', 'sibs_register_payment_status');
add_filter('wc_order_statuses', 'sibs_add_order_status');
add_filter('woocommerce_email_classes', 'payment_processed_woocommerce_email');

/**
 * Register new order statuses
 *  (Payment Authorized).
 */
function sibs_register_payment_status()
{
    register_post_status(sibsConstants::SIBS_ORDER_STATUS_AUTHORIZED, [
        'label'                     => _x('Payment Authorized', 'WooCommerce Order Status', sibsConstants::SIBS_TRANSLATE),
        'label_count'               => _n_noop('Payment Authorized ( %s )', 'Payment Authorized ( %s )', sibsConstants::SIBS_TRANSLATE),
        'exclude_from_search'       => false,
        'public'                    => true,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
    ]);

    register_post_status(sibsConstants::SIBS_ORDER_STATUS_PARTIALLY_CAPTURED, [
        'label'                     => _x('Payment Partially Captured', 'WooCommerce Order Status', sibsConstants::SIBS_TRANSLATE),
        'label_count'               => _n_noop('Payment Partially Captured ( %s )', 'Payment Partially Captured ( %s )', sibsConstants::SIBS_TRANSLATE),
        'exclude_from_search'       => false,
        'public'                    => true,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
    ]);

    register_post_status(sibsConstants::SIBS_ORDER_STATUS_PARTIALLY_REFUNDED, [
        'label'                     => _x('Payment Partially Refunded', 'WooCommerce Order Status', sibsConstants::SIBS_TRANSLATE),
        'label_count'               => _n_noop('Payment Partially Refunded ( %s )', 'Payment Partially Refunded ( %s )', sibsConstants::SIBS_TRANSLATE),
        'exclude_from_search'       => false,
        'public'                    => true,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
    ]);

    register_post_status(sibsConstants::SIBS_ORDER_STATUS_PENDING_REFUND, [
        'label'                     => _x('Payment Pending Refund', 'WooCommerce Order Status', sibsConstants::SIBS_TRANSLATE),
        'label_count'               => _n_noop('Payment Pending Refund ( %s )', 'Payment Pending Refund ( %s )', sibsConstants::SIBS_TRANSLATE),
        'exclude_from_search'       => false,
        'public'                    => true,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
    ]);
}

/**
 * Add new order statuses to woocommerce
 *  ( Payment Authorized ).
 *
 * @param array $order_status order status.
 */
function sibs_add_order_status($order_status)
{
    $order_status[sibsConstants::SIBS_ORDER_STATUS_AUTHORIZED]         = _x('Payment Authorized', 'Payment Authorized Order Status', sibsConstants::SIBS_TRANSLATE);
    $order_status[sibsConstants::SIBS_ORDER_STATUS_PARTIALLY_CAPTURED] = _x('Payment Partially Captured', 'Payment Partially Captured Order Status', sibsConstants::SIBS_TRANSLATE);
    $order_status[sibsConstants::SIBS_ORDER_STATUS_PARTIALLY_REFUNDED] = _x('Payment Partially Refunded', 'Payment Partially Refunded Order Status', sibsConstants::SIBS_TRANSLATE);
    $order_status[sibsConstants::SIBS_ORDER_STATUS_PENDING_REFUND]     = _x('Payment Pending Refund', 'Payment Pending Refund Order Status', sibsConstants::SIBS_TRANSLATE);

    return $order_status;
}

/**
 * Add sibs custom order status icon.
 */
function sibs_add_custom_order_status_icon()
{
    if (! is_admin()) {
        return;
    }
    ?>
	<style>
		.column-order_status mark.status-authorized {
			color: #94660c;
			background-color: #f8dda7;
		}

		.column-order_status mark.status-part-captured {
			color: #5b841b;
			background-color: #c6e1c6;
		}

		.column-order_status mark.status-part-refunded {
			color: #777777;
			background-color: #e5e5e5;
		}
	</style>
<?php
}

/**
 *  Add a custom email to the list of emails WooCommerce should load.
 *
 * @since 0.1
 * @param array $email_classes available email classes
 * @return array filtered available email classes
 */
function payment_processed_woocommerce_email($email_classes)
{
    // include our custom email class
    require 'includes/class-wc-payment-processed-email.php';

    // add the email class to the list of email classes that WooCommerce loads
    $email_classes['WC_Payment_Processed_Email'] = new WC_Payment_Processed_Email();

    return $email_classes;
}

function verify_billing_shipping_address()
{
    $char_billing_address_1 = ! empty($_POST['billing_address_1']) ? strlen($_POST['billing_address_1']) : 0;
    $char_billing_address_2 = ! empty($_POST['billing_address_2']) ? strlen($_POST['billing_address_2']) : 0;

    $total_billing = $char_billing_address_1 + $char_billing_address_2;

    if ($total_billing > 70) {
        wc_add_notice(__('<strong>Billing Street</strong> address exceeds 70 characters limit', sibsConstants::SIBS_TRANSLATE), 'error');
    }

    $char_shipping_address_1 = ! empty($_POST['shipping_address_1']) ? strlen($_POST['shipping_address_1']) : 0;
    $char_shipping_address_2 = ! empty($_POST['shipping_address_2']) ? strlen($_POST['shipping_address_2']) : 0;

    $total_shipping = $char_shipping_address_1 + $char_shipping_address_2;

    if ($total_shipping > 70) {
        wc_add_notice(__('<strong>Shipping Street</strong> address exceeds 70 characters limit', sibsConstants::SIBS_TRANSLATE), 'error');
    }
}
