<?php

namespace Sibs2;

defined('ABSPATH') || exit;

class sibsConstants
{
    const SIBS_PREFIX             = 'sibs';
    const SIBS_PLUGIN_PREFIX      = self::SIBS_PREFIX . '_stg';
    const SIBS_PLUGIN_PREFIX_NAME = self::SIBS_PREFIX . '-stg';
    // DEPRECATION VERSIONS
    const DEPRECATION_MYSQL_VERSION       = '5.5';
    const DEPRECATION_PHP_VERSION         = '7.4';  // https://www.php.net/releases/index.php
    const DEPRECATION_WORDPRESS_VERSION   = '5.9';  // https://codex.wordpress.org/WordPress_Versions
    const DEPRECATION_WOOCOMMERCE_VERSION = '7.4';  // https://developer.woocommerce.com/releases/

    // WEBHOOK
    const SIBS_WEBHOOK_ENDPOINT  = '/' . self::SIBS_PLUGIN_PREFIX_NAME . '/webhook';
    const SIBS_WEBHOOK_RETRY_QTY = 3;

    // LANGUAGE SETTINGS
    const SIBS_ACCEPTED_LANGUAGES = [
        'de_DE' => 'de',
        'el_GR' => 'el',
        'en_US' => 'en',
        'en_GB' => 'en',
        'es_ES' => 'es',
        'fr_FR' => 'fr',
        'it_IT' => 'it',
        'nl_NL' => 'nl',
        'pl_PL' => 'pl',
        'pt_PT' => 'pt',
        'ro_RO' => 'ro',
    ];

    const SIBS_ACCEPTED_LANGUAGES_REGION = [
        'de-DE' => 'de',
        'el-GR' => 'el',
        'en-US' => 'en',
        'en-GB' => 'en',
        'es-ES' => 'es',
        'fr-FR' => 'fr',
        'it-IT' => 'it',
        'nl-NL' => 'nl',
        'pl-PL' => 'pl',
        'pt-PT' => 'pt',
        'ro-RO' => 'ro',
    ];
    const SIBS_LANGUAGES = [
        'en' => 'English',
        'cs' => 'Czech',
        'de' => 'German',
        'fr' => 'French',
        'nl' => 'Dutch',
        'pl' => 'Polish',
    ];

    const SIBS_DEFAULT_LOCALE   = 'en_US';
    const SIBS_DEFAULT_LANGUAGE = 'en';

    // COUNTRY SETTINGS
    const SIBS_ACCEPTED_COUNTRIES = [
        // TODO:
    ];

    // REPORT ISSUE
    const SIBS_REPORT_ISSUE_EMAIL = 'stargate.support@sibs.com';

    // SPG PAYMENT TYPE CONSTANTS
    const SPG_PAYMENT_TYPE_AUTH = 'AUTH';
    const SPG_PAYMENT_TYPE_PREF = 'PREF';
    const SPG_PAYMENT_TYPE_PURS = 'PURS';
    const SPG_PAYMENT_TYPE_CAPT = 'CAPT';
    const SPG_PAYMENT_TYPE_RFND = 'RFND';
    const SPG_PAYMENT_TYPE_RVSL = 'RVSL';
    const SPG_PAYMENT_TYPE_RCON = 'RCON';
    const SPG_PAYMENT_TYPE_CAUT = 'CAUT';
    const SPG_PAYMENT_TYPE_CPRF = 'CPRF';
    const SPG_PAYMENT_TYPE_STIQ = 'STIQ';

    // ORDER STATUS CONSTANTS
    const ORDER_STATUS_PENDING            = 'pending';
    const ORDER_STATUS_PROCESSING         = 'processing';
    const ORDER_STATUS_ON_HOLD            = 'on-hold';
    const ORDER_STATUS_COMPLETED          = 'completed';
    const ORDER_STATUS_CANCELLED          = 'cancelled';
    const ORDER_STATUS_REFUNDED           = 'refunded';
    const ORDER_STATUS_FAILED             = 'failed';
    const ORDER_STATUS_PARTIALLY_CAPTURED = 'part-captured';
    const ORDER_STATUS_PARTIALLY_REFUNDED = 'part-refunded';
    const ORDER_STATUS_AUTHORIZED         = 'authorized';
    const ORDER_STATUS_PENDING_REFUND     = 'pend-refund';

    // WOOCOMMERCE ORDER STATUS CONSTANTS
    const WOOCOMMERCE_ORDER_STATUS_PENDING    = 'wc-' . self::ORDER_STATUS_PENDING;
    const WOOCOMMERCE_ORDER_STATUS_PROCESSING = 'wc-' . self::ORDER_STATUS_PROCESSING;
    const WOOCOMMERCE_ORDER_STATUS_ON_HOLD    = 'wc-' . self::ORDER_STATUS_ON_HOLD;
    const WOOCOMMERCE_ORDER_STATUS_COMPLETED  = 'wc-' . self::ORDER_STATUS_COMPLETED;
    const WOOCOMMERCE_ORDER_STATUS_CANCELLED  = 'wc-' . self::ORDER_STATUS_CANCELLED;
    const WOOCOMMERCE_ORDER_STATUS_REFUNDED   = 'wc-' . self::ORDER_STATUS_REFUNDED;
    const WOOCOMMERCE_ORDER_STATUS_FAILED     = 'wc-' . self::ORDER_STATUS_FAILED;

    // SIBS ORDER STATUS CONSTANTS
    const SIBS_ORDER_STATUS_PARTIALLY_CAPTURED = 'wc-' . self::ORDER_STATUS_PARTIALLY_CAPTURED;
    const SIBS_ORDER_STATUS_PARTIALLY_REFUNDED = 'wc-' . self::ORDER_STATUS_PARTIALLY_REFUNDED;
    const SIBS_ORDER_STATUS_AUTHORIZED         = 'wc-' . self::ORDER_STATUS_AUTHORIZED;
    const SIBS_ORDER_STATUS_PENDING_REFUND     = 'wc-' . self::ORDER_STATUS_PENDING_REFUND;

    // NO LOGS
    const SIBS_LOG          = self::SIBS_PLUGIN_PREFIX_NAME . '-log';
    const SIBS_INSTALL_LOG  = self::SIBS_PLUGIN_PREFIX_NAME . '-install-log';
    const SIBS_ADMIN_LOG    = self::SIBS_PLUGIN_PREFIX_NAME . '-admin-log';
    const SIBS_CRON_LOG     = self::SIBS_PLUGIN_PREFIX_NAME . '-cron-log';
    const SIBS_WEBHOOK_LOG  = self::SIBS_PLUGIN_PREFIX_NAME . '-webhook-log';
    const SIBS_DATA_LOG     = self::SIBS_PLUGIN_PREFIX_NAME . '-data-log';
    const SIBS_API_LOG      = self::SIBS_PLUGIN_PREFIX_NAME . '-api-log';

    // TRANSLATE
    const SIBS_TRANSLATE = 'sibs-woo-stg'; // Same as plugin name

    // PAYMENT METHOD
    const SIBS_PAYMENT_METHOD_CARD        = 'CARD';
    const SIBS_PAYMENT_METHOD_BLIK        = 'BLIK';
    const SIBS_PAYMENT_METHOD_PAYPAL      = 'PAYPAL';
    const SIBS_PAYMENT_METHOD_PAY_BY_LINK = 'PAY_BY_LINK';
    const SIBS_PAYMENT_METHOD_CC          = 'CC';
    const SIBS_PAYMENT_METHOD_DD          = 'DD';
    const SIBS_PAYMENT_METHOD_PBL         = 'PBL';
    const SIBS_PAYMENT_METHOD_PBLKV       = 'PBLKV';
    const SIBS_PAYMENT_METHOD_TOKEN       = 'TOKEN';
    const SIBS_PAYMENT_METHOD_XPAY        = 'XPAY';
    const SIBS_PAYMENT_METHOD_GPAY        = 'GPAY';
    const SIBS_PAYMENT_METHOD_APAY        = 'APAY';

    // PAYMENT METHOD ORDER
    const SIBS_PAYMENT_METHOD_ORDER_CREDIT_CARD         = self::SIBS_PLUGIN_PREFIX . '_cc';
    const SIBS_PAYMENT_METHOD_ORDER_CREDIT_CARD_SAVED   = self::SIBS_PLUGIN_PREFIX . '_ccsaved';
    const SIBS_PAYMENT_METHOD_ORDER_DEBIT_CARD          = self::SIBS_PLUGIN_PREFIX . '_dc';
    const SIBS_PAYMENT_METHOD_ORDER_DEBIT_CARD_SAVED    = self::SIBS_PLUGIN_PREFIX . '_dcsaved';
    const SIBS_PAYMENT_METHOD_ORDER_DIRECT_DEBIT        = self::SIBS_PLUGIN_PREFIX . '_dd';
    const SIBS_PAYMENT_METHOD_ORDER_DIRECT_DEBIT_SAVED  = self::SIBS_PLUGIN_PREFIX . '_ddsaved';
    const SIBS_PAYMENT_METHOD_ORDER_PAY_BY_LINK         = self::SIBS_PLUGIN_PREFIX . '_pbl';
    const SIBS_PAYMENT_METHOD_ORDER_PAY_BY_LINK_KEVIN   = self::SIBS_PLUGIN_PREFIX . '_pblkv';
    const SIBS_PAYMENT_METHOD_ORDER_BLIK                = self::SIBS_PLUGIN_PREFIX . '_blik';
    const SIBS_PAYMENT_METHOD_ORDER_XPAY                = self::SIBS_PLUGIN_PREFIX . '_xpay';
    const SIBS_PAYMENT_METHOD_ORDER_GPAY                = self::SIBS_PLUGIN_PREFIX . '_gpay';
    const SIBS_PAYMENT_METHOD_ORDER_APAY                = self::SIBS_PLUGIN_PREFIX . '_apay';

    // REFUND STATUS
    const SIBS_PAYMENT_STATUS_REFUND_COMPLETED = 'completed';
    const SIBS_PAYMENT_STATUS_REFUND_PROGRESS  = 'progress';
    const SIBS_PAYMENT_STATUS_REFUND_FAILED    = 'failed';

    // SIBS RESULT
    const SIBS_RESULT_SUCCESS       = 'Success';
    const SIBS_RESULT_PARTIAL       = 'Partial';
    const SIBS_RESULT_IN_PROCESSING = 'InProcessing';
    const SIBS_RESULT_PENDING       = 'Pending';
    const SIBS_RESULT_DECLINED      = 'Declined';
    const SIBS_RESULT_TIMEOUT       = 'Timeout';
    const SIBS_RESULT_ERROR         = 'Error';

    // ACKNOWLEDGEMENT
    const SIBS_ACK = 'ACK';
    const SIBS_NOK = 'NOK';

    // WOOCOMMERCE META INFO
    const WOOCOMMERCE_POST_TYPE_SHOP_ORDER = 'shop_order';

    // SIBS TOKEN
    const SIBS_TOKEN_NONE         = 'none';
    const SIBS_TOKEN_TOKENIZATION = 'tokenization';
    const SIBS_TOKEN_ONECLICK     = 'oneclick';

    // WEBHOOK
    const WEBHOOK_TEST = 'WebhookTest';

    // PAYMENT SETTINGS
    const SIBS_PAYMENT_DATE_VALUE = '3';
    const SIBS_PAYMENT_DATE_UNIT  = 'day';
    const SIBS_NUMBER_OF_RETRIES  = '30';
    const SIBS_RETRY_DELAY        = '1';
}
