<?php

namespace Sibs2;

defined('ABSPATH') || exit;

class sibsException extends \Exception
{
    /**
     * @var string
     */
    protected $details;

    /**
     * Constructor.
     *
     * @param string $details
     * @param string $log_source
     */
    public function __construct($details, $log_source = sibsConstants::SIBS_LOG)
    {
        $this->details = $details;
        parent::__construct();

        if (function_exists('wc_get_logger')) {
            sibsLogger::error($this->getErrorMessage(), $log_source);
        }
    }

    /**
     * get Exception Message.
     *
     * @return string
     */
    public function getExceptionMessage()
    {
        return "{$this->details}";
    }

    /**
     * Get Error Message.
     *
     * @return string
     */
    public function getErrorMessage()
    {
        return "SIBS Error: {$this->details}";
    }
}
