<?php

namespace Sibs2;

defined('ABSPATH') || exit;

class sibsFunctions
{
    /**
     * SIBS Name Format.
     *
     * @param string $name
     * @return string
     */
    public static function sibs_name_format($name)
    {
        $name_lower = strtolower($name);

        return str_replace('_', '-', $name_lower);
    }

    /**
     * SIBS Undercore Name Format.
     *
     * @param string $name
     * @return string
     */
    public static function sibs_underscore_name_format($name)
    {
        $name_lower = strtolower($name);

        return str_replace('-', '_', $name_lower);
    }

    /**
     * SIBS Set Number Format.
     *
     * @param mixed $number
     * @return string
     */
    public static function sibs_set_number_format($number)
    {
        $locale_info     = localeconv();
        $decimal_pointer = $locale_info['decimal_point'];

        $float_number = floatval(str_replace($decimal_pointer, '.', $number));

        return number_format($float_number, 2, '.', '');
    }

    /**
     * SIBS Get Plugin URL.
     *
     * @return string
     */
    public static function sibs_get_plugin_url()
    {
        return untrailingslashit(plugins_url('/', constant('SIBS_PLUGIN_FILE')));
    }

    /**
     * SIBS Is Billing Country Accepted.
     *
     * @return bool
     */
    public static function sibs_is_billing_country_accepted()
    {
        $customer = WC()->customer;

        $obj_array = (array) $customer;
        $changes   = $obj_array["\0*\0" . 'changes'];
        $country   = $changes['shipping']['country'];

        if (is_null($country)) {
            $country = $customer->country;
        }

        if (in_array($country, sibsConstants::SIBS_ACCEPTED_COUNTRIES)) {
            return true;
        }

        return false;
    }

    /**
     * Undocumented function.
     *
     * @return void
     */
    public static function get_language()
    {
        return sibsConfig::getLanguageDefault();
        // remover no futuro
        $accepted_languages = array_merge(sibsConstants::SIBS_ACCEPTED_LANGUAGES, sibsConstants::SIBS_ACCEPTED_LANGUAGES_REGION);
        $site_language      = get_bloginfo('language');

        if (in_array($site_language, $accepted_languages)) {
            return strtolower(substr($site_language, 0, 2));
        }
    }

    /**
     * Get Environment.
     *
     * @return array
     */
    public static function get_environment()
    {
        try {
            $json_file = file_get_contents(plugin_dir_path(__DIR__) . '/environment.json');
        } catch (\Exception $e) {
            sibsLogger::error("Caught exception: {$e->getMessage()}", sibsConstants::SIBS_LOG);
        }

        $environment_file = json_decode($json_file, true);

        return $environment_file;
    }

    /**
     * Translate.
     *
     * @param string $string
     * @param string $textdomain
     * @param string $locale
     * @return string
     */
    public static function __2($string, $textdomain, $locale)
    {
        global $l10n;

        if (isset($l10n[$textdomain])) {
            $backup = $l10n[$textdomain];
        }

        $mo_file = plugin_dir_path(__DIR__) . sibsConstants::SIBS_TRANSLATE . '/languages/' . sibsConstants::SIBS_TRANSLATE . "-{$locale}.mo";
        load_textdomain($textdomain, $mo_file, $locale);
        $translation = __($string, $textdomain);

        if (isset($backup)) {
            $l10n[$textdomain] = $backup;
        }

        return $translation;
    }

    /**
     * Echo Translate.
     *
     * @param string $string
     * @param string $textdomain
     * @param string $locale
     * @return string
     */
    public static function _e2($string, $textdomain, $locale)
    {
        echo self::__2($string, $textdomain, $locale);
    }
}
