<?php

namespace Sibs2;

defined('ABSPATH') || exit;

class sibsPayments
{
    /**
     * Save Data.
     *
     * @param array $post
     * @return true
     */
    public static function saveData($post)
    {
        sibsConfig::setTerminalId($post[sibsConfig::SIBS_GENERAL_CONFIG . '_merchant_no']);
        sibsConfig::setClientId($post[sibsConfig::SIBS_GENERAL_CONFIG . '_client_id']);
        sibsConfig::setToken($post[sibsConfig::SIBS_GENERAL_CONFIG . '_bearer_token']);
        sibsConfig::setEnvironment($post[sibsConfig::SIBS_GENERAL_CONFIG . '_environment']);
        sibsConfig::setWebhookSecret($post[sibsConfig::SIBS_GENERAL_CONFIG . '_webhook_secret']);
        sibsConfig::setLanguageDefault($post[sibsConfig::SIBS_GENERAL_CONFIG . '_language']);
        sibsConfig::setForceDisableClickToPay($post[sibsConfig::SIBS_GENERAL_CONFIG . '_force_disable_click_to_pay']);

        return true;
    }

    /**
     * Save Data Style Settings.
     *
     * @param array $post
     * @return true
     */
    public static function saveDataStyleSettings($post)
    {
        $sibs_stg_style_layout = $post[sibsConfig::SIBS_STYLE_CONFIG . '_layout'];
        sibsConfig::setStyleOption('layout', $sibs_stg_style_layout);

        $sibs_stg_style_layout_primary = $post[sibsConfig::SIBS_STYLE_CONFIG . '_layout_primary'];
        sibsConfig::setStyleOption('layout_primary', $sibs_stg_style_layout_primary);

        $sibs_stg_style_layout_surface = $post[sibsConfig::SIBS_STYLE_CONFIG . '_layout_surface'];
        sibsConfig::setStyleOption('layout_surface', $sibs_stg_style_layout_surface);

        $sibs_stg_style_layout_text_color = $post[sibsConfig::SIBS_STYLE_CONFIG . '_layout_text_color'];
        sibsConfig::setStyleOption('layout_text_color', $sibs_stg_style_layout_text_color);

        $sibs_stg_style_layout_header_color = $post[sibsConfig::SIBS_STYLE_CONFIG . '_layout_header_color'];
        sibsConfig::setStyleOption('layout_header_color', $sibs_stg_style_layout_header_color);

        $sibs_stg_style_theme = $post[sibsConfig::SIBS_STYLE_CONFIG . '_theme'];
        sibsConfig::setStyleOption('theme', $sibs_stg_style_theme);

        $sibs_stg_style_theme_secondary_color = $post[sibsConfig::SIBS_STYLE_CONFIG . '_theme_secondary_color'];
        sibsConfig::setStyleOption('theme_secondary_color', $sibs_stg_style_theme_secondary_color);

        $sibs_stg_style_theme_background_color = $post[sibsConfig::SIBS_STYLE_CONFIG . '_theme_background_color'];
        sibsConfig::setStyleOption('theme_background_color', $sibs_stg_style_theme_background_color);

        $sibs_stg_style_theme_border_color = $post[sibsConfig::SIBS_STYLE_CONFIG . '_theme_border_color'];
        sibsConfig::setStyleOption('theme_border_color', $sibs_stg_style_theme_border_color);

        $sibs_stg_style_theme_header_text = $post[sibsConfig::SIBS_STYLE_CONFIG . '_theme_header_text'];
        sibsConfig::setStyleOption('theme_header_text', $sibs_stg_style_theme_header_text);

        $sibs_stg_style_font = $post[sibsConfig::SIBS_STYLE_CONFIG . '_font'];
        sibsConfig::setStyleOption('font', $sibs_stg_style_font);

        return true;
    }

    /**
     * Deprecation Message.
     *
     * @param string $message
     * @param bool $isDeprecated
     * @return void
     */
    public static function deprecationMessage($message, $isDeprecated = false)
    {
        if ($isDeprecated) {
            ?>
                <strong class="text-danger"><?= $message ?> (<?= __('deprecated', sibsConstants::SIBS_TRANSLATE) ?>)</strong>
            <?php
        } else {
            ?>
                <strong class="text-success"><?= $message ?></strong>
            <?php
        }
    }

    /**
     * MySQL Deprecation Message.
     *
     * @return bool
     */
    public static function mysql_version_deprecated()
    {
        return version_compare(sibsConfig::getMysqlVersion(), sibsConstants::DEPRECATION_MYSQL_VERSION, '<');
    }

    /**
     * PHP Deprecation Message.
     *
     * @return bool
     */
    public static function php_version_deprecated()
    {
        return version_compare(sibsConfig::getPhpVersion(), sibsConstants::DEPRECATION_PHP_VERSION, '<');
    }

    /**
     * Wordpress Deprecation Message.
     *
     * @return bool
     */
    public static function wordpress_version_deprecated()
    {
        return version_compare(sibsConfig::getFrameworkVersion(), sibsConstants::DEPRECATION_WORDPRESS_VERSION, '<');
    }

    /**
     * Woocommerce Deprecation Message.
     *
     * @return bool
     */
    public static function woocommerce_version_deprecated()
    {
        return version_compare(sibsConfig::getEcommerceVersion(), sibsConstants::DEPRECATION_WOOCOMMERCE_VERSION, '<');
    }

    /**
     * Get Test Decryptor.
     *
     * @return sibsWebhookDecryptor
     */
    public static function getTestDecryptor(): sibsWebhookDecryptor
    {
        $iv      = '000000000000000000000000';
        $authTag = 'CE573FB7A41AB78E743180DC83FF09BD';
        $content = '0A3471C72D9BE49A8520F79C66BBD9A12FF9';
        $secret  = '000102030405060708090a0b0c0d0e0f000102030405060708090a0b0c0d0e0f';

        return (new sibsWebhookDecryptor($content, $iv, $authTag, $secret))
            ->setSuppressLog(true);
    }

    /**
     * Get Entity Available.
     *
     * @param string $entity
     * @return bool
     */
    public static function getEntityAvailable(string $entity): bool
    {
        $testDecryptor = self::getTestDecryptor();

        switch($entity) {
            case 'sodium':
                return $testDecryptor->canSodiumUseAeadAes256Gcm();
            case 'libsodium':
                return $testDecryptor->canLibSodiumUseAeadAes256Gcm();
            case 'sodium_compact':
                return $testDecryptor->canSodiumCompactUseAeadAes256Gcm();
            case 'open_ssl':
                return $testDecryptor->canOpenSSLUseAeadAes256Gcm();
            case 'all':
            default:
                return $testDecryptor->canUseAes256Gcm();
        }
    }

    /**
     * Add SIBS Settings page sodium description.
     */
    public static function sibs_page_content_sodium_description_test()
    {
        $testDecryptor = self::getTestDecryptor();

        try {
            $sibsWebhookData = $testDecryptor->execute();
            ?>
                <span class="text-success">
                    <?= sibsLogger::prettify($sibsWebhookData->jsonSerialize()) ?>
                </span>
            <?php
        } catch (SibsException $e) {
            ?>
                <strong class="text-danger">
                    <?= __('Error to decrypt', SibsConstants::SIBS_TRANSLATE) ?>
                </strong>
            <?php
        }
    }

    /**
     * Get Avaliable Message.
     *
     * @param string $entity
     */
    public static function availableMessage(string $entity)
    {
        $isAvailable = self::getEntityAvailable($entity);

        if ($isAvailable) {
            ?>
                <span class="text-success">
                    <?= __('Available', SibsConstants::SIBS_TRANSLATE) ?>
                </span>
            <?php
        } else {
            ?>
                <strong class="text-danger">
                    <?= __('Not Available', SibsConstants::SIBS_TRANSLATE) ?>
                </strong>
            <?php
        }
    }

    /**
     * Decrypt Description.
     *
     * @return void
     */
    public static function decrypt_description()
    {
        ?>
            <h6 class="mb-3"><?= __('Decryption Methods', SibsConstants::SIBS_TRANSLATE) ?></h6>

            <div class="text-black">
                <strong><?= __('Sodium Extension', SibsConstants::SIBS_TRANSLATE) ?>:</strong>
                <?= self::availableMessage('sodium') ?>
            </div>
            <div class="text-black">
                <strong><?= __('LibSodium Extension', SibsConstants::SIBS_TRANSLATE) ?>:</strong>
                <?= self::availableMessage('libsodium') ?>
            </div>
            <div class="text-black">
                <strong><?= __('Sodium Compact', SibsConstants::SIBS_TRANSLATE) ?>:</strong>
                <?= self::availableMessage('sodium_compact') ?>
            </div>
            <div class="text-black">
                <strong><?= __('Open SSL Extension', SibsConstants::SIBS_TRANSLATE) ?>:</strong>
                <?= self::availableMessage('open_ssl') ?>
            </div>

            <h6 class="mt-3 mb-3"><?= __('Decryption Availability', SibsConstants::SIBS_TRANSLATE) ?></h6>

            <div class="text-black">
                <strong><?= __('Webhook Decryption', SibsConstants::SIBS_TRANSLATE) ?>:</strong>
                <?= self::availableMessage('all') ?>
            </div>
            <div class="text-black">
                <strong><?= __('Webhook Decryption Test', SibsConstants::SIBS_TRANSLATE) ?>:</strong>
                <?= self::sibs_page_content_sodium_description_test() ?>
            </div>
        <?php
    }

    /**
     * Webhook Description.
     *
     * @return string
     */
    public static function webhook_description()
    {
        return sprintf(
            __(
                "Place here your SIBS' WebHook Secret. <br> Provide this WebHook URL %s to your SIBS point of contact",
                sibsConstants::SIBS_TRANSLATE
            ),
            '<code>' . sibsConfig::getWebhookURL() . '</code>'
        );
    }

    /**
     * Get Entity Enable.
     *
     * @param string $entity
     * @return bool
     */
    public static function getEntityEnable(string $entity): bool
    {
        switch($entity) {
            case 'creditcard':
                return sibsConfig::getCreditCardEnabled();
            case 'blik':
                return sibsConfig::getBlikEnabled();
            case 'pblkv':
                return sibsConfig::getPayByLinkEnabled();
            case 'pbl':
                return sibsConfig::getPayByLink2Enabled();
            case 'xpay':
                return sibsConfig::getXpayEnabled();
            default:
                return false;
        }
    }

    /**
     * Get Enable Message.
     *
     * @param string $entity
     */
    public static function enabledMessage(string $entity)
    {
        $isEnable = self::getEntityEnable($entity);

        if ($isEnable) {
            ?>
                <span class="text-success">
                    <?= __('Enabled', SibsConstants::SIBS_TRANSLATE) ?>
                </span>
            <?php
        } else {
            ?>
                <strong class="text-danger">
                    <?= __('Not Enabled', SibsConstants::SIBS_TRANSLATE) ?>
                </strong>
            <?php
        }
    }

    /**
     * Add SIBS Settings page active methods.
     */
    public static function sibs_page_content_active_methods()
    {
        ?>
            <div class="text-black">
                <a class="link-offset-2 link-underline link-underline-opacity-0" href="<?= sibsConfig::getCreditCardURL() ?>">
                    <strong>
                        <?= __('Credit Card', SibsConstants::SIBS_TRANSLATE) ?>:
                    </strong>
                    <?= self::enabledMessage('creditcard') ?>
                </a>
            </div>
            <div class="text-black">
                <a class="link-offset-2 link-underline link-underline-opacity-0" href="<?= sibsConfig::getBlikURL() ?>">
                    <strong>
                        <?= __('BLIK', SibsConstants::SIBS_TRANSLATE) ?>:
                    </strong>
                    <?= self::enabledMessage('blik') ?>
                </a>
            </div>
           <!--  <div class="text-black">
                <a class="link-offset-2 link-underline link-underline-opacity-0" href="<?= sibsConfig::getPayByLinkURL() ?>">
                    <strong>
                        <?= __('Pay by Link kevin', SibsConstants::SIBS_TRANSLATE) ?>:
                    </strong>
                    <?= self::enabledMessage('pblkv') ?>
                </a>
            </div> -->
            <div class="text-black">
                <a class="link-offset-2 link-underline link-underline-opacity-0" href="<?= sibsConfig::getPayByLinkURL() ?>">
                    <strong>
                        <?= __('Pay by Link', SibsConstants::SIBS_TRANSLATE) ?>:
                    </strong>
                    <?= self::enabledMessage('pbl') ?>
                </a>
            </div>            <div class="text-black">
                <a class="link-offset-2 link-underline link-underline-opacity-0" href="<?= sibsConfig::getXpayURL() ?>">
                    <strong>
                        <?= __('Xpay', SibsConstants::SIBS_TRANSLATE) ?>:
                    </strong>
                    <?= self::enabledMessage('xpay') ?>
                </a>
            </div>
        <?php
    }

    /**
     * Get Table Ok Message.
     *
     * @param string $tableName
     */
    public static function tableOkMessage(string $tableName)
    {
        $isTableOk = sibsConfig::checkDatabaseHealth($tableName);

        if ($isTableOk) {
            ?>
                <span class="text-success">
                    <?= __('Ok', SibsConstants::SIBS_TRANSLATE) ?>
                </span>
            <?php
        } else {
            ?>
                <strong class="text-danger">
                    <?= __('Not Ok', SibsConstants::SIBS_TRANSLATE) ?>
                </strong>
            <?php
        }
    }

    /**
     * Add SIBS Settings page database health.
     */
    public static function sibs_page_content_database_health()
    {
        ?>
            <div class="text-black">
                <strong>
                    <?= sibsConfig::getTransactionTableName() ?>:
                </strong>
                <?= self::tableOkMessage(sibsConfig::getTransactionTableName()) ?>
            </div>
            <div class="text-black">
                <strong>
                    <?= sibsConfig::getPaymentInformationTableName() ?>:
                </strong>
                <?= self::tableOkMessage(sibsConfig::getPaymentInformationTableName()) ?>
            </div>
            <div class="text-black">
                <strong>
                    <?= sibsConfig::getTokenizationTableName() ?>:
                </strong>
                <?= self::tableOkMessage(sibsConfig::getTokenizationTableName()) ?>
            </div>
            <div class="text-black">
                <strong>
                    <?= sibsConfig::getWebhookCallTableName() ?>:
                </strong>
                <?= self::tableOkMessage(sibsConfig::getWebhookCallTableName()) ?>
            </div>
        <?php
    }

    /**
     * Add SIBS Settings page report feedback.
     */
    public static function sibs_page_content_report_feedback()
    {
        ?>
            <div class="report_feedback">
                <script type="text/javascript">
                    window.SIBS_VERSION = "<?= sibsConfig::getFrameworkVersion() ?>";
                    window.SIBS_PLUGIN_VERSION = "<?= sibsConfig::getPluginVersion() ?>";
                    window.SIBS_PHP_VERSION = "<?= sibsConfig::getPhpVersion() ?>";
                    window.SIBS_CLIENT = "<?= sibsConfig::getClientId() ?>";
                    window.SIBS_FRAMEWORK = "<?= sibsConfig::getEcommerceName() ?>";
                    window.SIBS_PROJECT = "<?= sibsConfig::getSibsProject() ?>";
                    window.SIBS_URL_REPORT = "<?= sibsConfig::getReportBugUrl() ?>";
                </script>
                <script src="<?= sibsConfig::getReportBugScriptUrl() ?>" id="sibs_bug_report_script-js"></script>
                <button class="button-secondary modal__button" id="sibs-open-modal">
                    <?= __('Report', SibsConstants::SIBS_TRANSLATE) ?>
                </button>
            </div>
        <?php
    }

    /**
     * Other Description.
     *
     * @return void
     */
    public static function other_description()
    {
        ?>
            <h6 class="mb-3">
                <?= __('Enabled Payment Methods', SibsConstants::SIBS_TRANSLATE) ?>
                <a href="<?= sibsConfig::getPaymentsURL() ?>">
                    <span class="dashicons dashicons-money-alt"
                        style="text-decoration: none;vertical-align: middle; font-size: 17px;">
                    </span>
                </a>
            </h6>
            <?= self::sibs_page_content_active_methods() ?>

            <h6 class="mt-3 mb-3"><?= __('Database Health', SibsConstants::SIBS_TRANSLATE) ?></h6>
            <?= self::sibs_page_content_database_health() ?>

            <!-- <h4>
                <?= __('Report a Feedback or a Bug', SibsConstants::SIBS_TRANSLATE) ?>
                <a href="<?= sibsConfig::getLogsURL() ?>">
                    <span class="dashicons dashicons-media-text"
                        style="text-decoration: none;vertical-align: middle; font-size: 17px;">
                    </span>
                </a>
            </h4>
            <?= self::sibs_page_content_report_feedback() ?> -->
        <?php
    }

    /**
     * Version Description.
     *
     * @return void
     */
    public static function version_description()
    {
        ?>
            <div class="text-black">
                <strong><?= __('MySQL Version', sibsConstants::SIBS_TRANSLATE) ?>:</strong>
                <?= self::deprecationMessage(sibsConfig::getMysqlVersion(), self::mysql_version_deprecated()) ?>
            </div>
            <div class="text-black">
                <strong><?= __('PHP Version', sibsConstants::SIBS_TRANSLATE) ?>:</strong>
                <?= self::deprecationMessage(sibsConfig::getPhpVersion(), self::php_version_deprecated()) ?>
            </div>
            <div class="text-black">
                <strong><?= __('Wordpress Version', sibsConstants::SIBS_TRANSLATE) ?>: </strong>
                <?= self::deprecationMessage(sibsConfig::getFrameworkVersion(), self::wordpress_version_deprecated()) ?>
            </div>
            <div class="text-black">
                <strong><?= __('Woocommerce Version', sibsConstants::SIBS_TRANSLATE) ?>: </strong>
                <?= self::deprecationMessage(sibsConfig::getEcommerceVersion(), self::woocommerce_version_deprecated()) ?>
            </div>
            <div class="text-black">
                <strong><?= __('SIBS Plugin Version', sibsConstants::SIBS_TRANSLATE) ?>: </strong>
                <?= self::deprecationMessage(sibsConfig::getPluginVersion(), false) ?>
            </div>
            <div class="text-black">
                <strong><?= __('Wordpress Universal hour', sibsConstants::SIBS_TRANSLATE) ?>: </strong>
                <?= self::deprecationMessage(sibsConfig::getStoreCurrentTime('Y-m-d H:i:s', false, true), false) ?>
            </div>
            <div class="text-black">
                <strong><?= __('Wordpress Local hour', sibsConstants::SIBS_TRANSLATE) ?>: </strong>
                <?= self::deprecationMessage(wp_date('Y-m-d H:i:s'), false) ?>
            </div>
            <div class="text-black">
                <strong><?= __('Wordpress Local hour for SIBS', sibsConstants::SIBS_TRANSLATE) ?>: </strong>
                <?= self::deprecationMessage(wp_date('Y-m-d\TH:i:s.vP'), false) ?>
            </div>
            
        <?php
    }

    /**
     * Wizard Login Section.
     *
     * @return void
     */
    public static function sibs_page_content_wizard_login()
    {
        ?>
            <div id="div-login-sibs" class="sibs-section-content">
                <div id="divLoginSibs">
                    <form id="formLoginSibs">
                        <table class="form-table" role="presentation">
                            <thead>
                                <tr>
                                    <th scope="row" colspan="2">
                                        <h2><?= __('Login to your SIBS Backoffice', SibsConstants::SIBS_TRANSLATE) ?></h2>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td scope="row">
                                        <label for="loginSibs">
                                            <?= __('E-mail', sibsConstants::SIBS_TRANSLATE) ?>
                                        </label> 
                                        <input type="text" value="" placeholder="<?= __('Type your e-mail', sibsConstants::SIBS_TRANSLATE) ?>"
                                            id="loginSibs"/>
                                        <span id="errorLoginSibs" class="error"></span>
                                    </td>
                                    <td scope="row">
                                        <label for="passwordSibs">
                                            <?= __('Password', sibsConstants::SIBS_TRANSLATE) ?>
                                        </label>
                                        <input type="password" value="" placeholder="<?= __('Enter your password', sibsConstants::SIBS_TRANSLATE) ?>"
                                            id="passwordSibs"/>
                                        <span id="errorPassSibs" class="error"></span>
                                    </td>
                                </tr>
                                <tr>
                                    <td scope="row" colspan="2">
                                        <label for="fenvironment">
                                            <?= __('Environment', sibsConstants::SIBS_TRANSLATE) ?>
                                        </label> 
                                        <select name="fenvironment" id="fenvironment"></select>
                                        <span id="errorEnvironmentSibs" class="error"></span>
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td scope="row" colspan="2">
                                        <button type="button" class="button button-primary" id="firstLoginSibs">
                                            <?= __('Login', sibsConstants::SIBS_TRANSLATE) ?>
                                        </button>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </form>
                </div>
                <div id="activateLoginSibs">
                    <form id="formActvateLoginSibs">
                        <table class="form-table" role="presentation">
                            <thead>
                                <tr>
                                    <th scope="row">
                                        <h2><?= __('Enter the activation code you received via SMS', SibsConstants::SIBS_TRANSLATE) ?></h2>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td scope="row">
                                        <label for="activationCode">
                                            <?= __('Activation Code', sibsConstants::SIBS_TRANSLATE) ?>
                                        </label>
                                        <input type="text" value="" placeholder="<?= __('Enter your activation code', sibsConstants::SIBS_TRANSLATE) ?>"
                                            id="activationCode"/>
                                        <span id="errorActivationCode" class="error"> </span>
                                    </td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td scope="row">
                                        <button type="button" class="button button-secondary" id="requestNewcode" class="whiteButton">
                                            <?= __('Request new code', sibsConstants::SIBS_TRANSLATE) ?>
                                        </button>
                                        <button type="button" class="button button-primary" id="secondLoginSibs">
                                            <?= __('Confirm', sibsConstants::SIBS_TRANSLATE) ?>
                                        </button>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </form>
                </div>
            </div>
        <?php
    }

    /**
     * Wizard Terminal Section.
     *
     * @return void
     */
    public static function sibs_page_content_wizard_terminal()
    {
        ?>
            <div id="div-terminal-sibs" class="sibs-section-content">
                <table class="form-table" role="presentation">
                    <thead>
                        <tr>
                            <th scope="row">
                                <h2><?= __('Select the terminal you want to configure', SibsConstants::SIBS_TRANSLATE) ?></h2>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td scope="row">
                                <select id="selectTerminalOptions">
                                    <option value=""><?= __('Loading', sibsConstants::SIBS_TRANSLATE) ?>...</option>
                                </select>
                                <span id="errorSelectTerminalOptions" class="error"> </span>
                            </td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td scope="row">
                                <button type="button" class="button button-primary" id="terminalTabButton">
                                    <?= __('Next', sibsConstants::SIBS_TRANSLATE) ?>
                                </button>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        <?php
    }

    /**
     * Wizard Webhook Section.
     *
     * @return void
     */
    public static function sibs_page_content_wizard_webhooks()
    {
        ?>
            <div id="div-webhooks-sibs" class="sibs-section-content">
                <table class="form-table" role="presentation">
                    <thead>
                        <tr>
                            <th scope="row" colspan="2">
                                <h2><?= __('Check the data and change the Webhook if necessary', SibsConstants::SIBS_TRANSLATE) ?></h2>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td scope="row" colspan="2">
                                <select id="selectClientIDWebhookSecret" class="sibsWizardSelectField">
                                    <option value=""><?= __('Loading', sibsConstants::SIBS_TRANSLATE) ?>...</option>
                                </select>
                                <span id="errorSelectClientIDWebhookSecret" class="error"> </span>
                            </td>
                        </tr>
                        <tr>
                            <td scope="row">
                                <label for="unconfirmedIdTerminal"><?= __('Terminal ID', sibsConstants::SIBS_TRANSLATE) ?></label>
                                <input type="text" placeholder="<?= __('Terminal ID', sibsConstants::SIBS_TRANSLATE) ?>"
                                    id="unconfirmedIdTerminal" class="sibsBlockedField"/>
                            </td>
                            <td scope="row">
                                <label for="unconfirmedClientId"><?= __('Client ID', sibsConstants::SIBS_TRANSLATE) ?></label>
                                <input type="text" placeholder="<?= __('Client ID', sibsConstants::SIBS_TRANSLATE) ?>"
                                    id="unconfirmedClientId" class="sibsBlockedField"/>
                            </td>
                        </tr>
                        <tr>
                            <td scope="row">
                                <label for="unconfirmedBearerToken"><?= __('Bearer Token', sibsConstants::SIBS_TRANSLATE) ?></label>
                                <textarea placeholder="<?= __('Bearer Token', sibsConstants::SIBS_TRANSLATE) ?>"
                                    id="unconfirmedBearerToken" class="sibsBlockedField" rows="7"></textarea>
                            </td>
                            <td scope="row" class="sibsWizardTdWithTextArea">
                                <label for="unconfirmedWebhookSecret"><?= __('WebHook Secret', sibsConstants::SIBS_TRANSLATE) ?></label>
                                <input type="text" placeholder="<?= __('WebHook Secret', sibsConstants::SIBS_TRANSLATE) ?>"
                                    id="unconfirmedWebhookSecret" class="sibsBlockedField"/>
                            </th>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td scope="row" colspan="2">
                                <button type="button" class="button button-secondary" class="previousWizard whiteButton">
                                    <?= __('Back', sibsConstants::SIBS_TRANSLATE) ?>
                                </button>
                                <button type="button" class="button button-primary" id="unconfirmedData">
                                    <?= __('Finish', sibsConstants::SIBS_TRANSLATE) ?>
                                </button>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        <?php
    }
}
