<?php

namespace Sibs2;

defined('ABSPATH') || exit;

class sibsVersionController
{
    /**
     * Verify if is a new instalation.
     *
     * @return bool
     */
    public static function is_new_instalation()
    {
        return empty(sibsConfig::getPluginOption('db_version'));
    }

    /**
     * Verify if it's install an upgrade.
     *
     * @return bool
     */
    public static function is_upgrading()
    {
        if (self::is_new_instalation()) {
            return false;
        }

        return version_compare(sibsConfig::getPluginOption('db_version'), constant('SIBS_VERSION'), 'lt');
    }

    /**
     * Verify if it's install the same version.
     *
     * @return bool
     */
    public static function is_same_version()
    {
        if (self::is_new_instalation()) {
            return false;
        }

        return version_compare(sibsConfig::getPluginOption('db_version'), constant('SIBS_VERSION'), 'eq');
    }

    /**
     * Verify if it's install an downgrade.
     *
     * @return bool
     */
    public static function is_dowgrading()
    {
        if (self::is_new_instalation()) {
            return false;
        }

        return version_compare(sibsConfig::getPluginOption('db_version'), constant('SIBS_VERSION'), 'gt');
    }

    /**
     * Need to migrate DB.
     *
     * @return bool
     */
    public static function need_to_migrate_db()
    {
        return self::is_new_instalation() || self::is_upgrading();
    }

    /**
     * Need to seed DB.
     *
     * @param string $reference_version
     * @return bool
     */
    public static function need_to_seed_db($reference_version)
    {
        if (self::is_new_instalation()) {
            return false;
        }

        return version_compare(sibsConfig::getPluginOption('db_version'), $reference_version, 'lt') &&
            version_compare(constant('SIBS_VERSION'), $reference_version, 'ge');
    }

    /**
     * Fix Sibs version.
     *
     * If has Plugin version but not DB version, this will fix it
     * If has DB version but not Plugin version, this will fix it
     */
    public static function fix_version_options()
    {
        if (! empty(sibsConfig::getPluginOption('plugin_version')) && empty(sibsConfig::getPluginOption('db_version'))) {
            sibsConfig::setPluginOption('db_version', sibsConfig::getPluginOption('plugin_version'));
        }

        if (! empty(sibsConfig::getPluginOption('db_version')) && empty(sibsConfig::getPluginOption('plugin_version'))) {
            sibsConfig::setPluginOption('plugin_version', sibsConfig::getPluginOption('db_version'));
        }
    }

    /**
     * Update Sibs version.
     */
    public static function update_sibs_version()
    {
        if (self::is_new_instalation() || self::is_upgrading()) {
            sibsConfig::setPluginOption('plugin_version', constant('SIBS_VERSION'));
            sibsConfig::setPluginOption('db_version', constant('SIBS_VERSION'));
        } elseif (self::is_dowgrading()) {
            sibsConfig::setPluginOption('plugin_version', constant('SIBS_VERSION'));
        }
    }

    public static function sibs_default_language()
    {
        if (self::is_new_instalation() || self::is_upgrading() || ! empty(sibsConfig::getPluginOption('sibs_default_language'))) {
            sibsConfig::setPluginOption('sibs_default_language', sibsConstants::SIBS_DEFAULT_LANGUAGE);
        }
    }
}
