<?php

namespace Sibs2;

defined('ABSPATH') || exit;

use JsonSerializable;

class sibsWebhookData implements JsonSerializable
{
    /**
     * @var bool
     */
    private $isTest;

    /**
     * @var array
     */
    private $content;

    /**
     * Constructor.
     *
     * @param string $content
     */
    public function __construct(string $content = '')
    {
        if (strpos($content, 'WebhookTest') === 0) {
            $this->isTest  = true;
            $this->content = [];
        } else {
            $this->isTest  = false;
            $this->content = json_decode($content, true) ?? [];
        }
    }

    /**
     * @return bool
     */
    public function isTest(): bool
    {
        return $this->isTest;
    }

    /**
     * @return array
     */
    public function getContent(): array
    {
        return $this->content;
    }

    /**
     * @return bool
     */
    public function hasNotificationId(): bool
    {
        return array_key_exists('notificationID', $this->content);
    }

    /**
     * @return string
     */
    public function getNotificationId(): string
    {
        return $this->hasNotificationId() ? $this->content['notificationID'] : '';
    }

    /**
     * @return array
     */
    public function jsonSerialize(): array
    {
        return $this->content;
    }
}
