<?php
    defined( 'ABSPATH' ) || exit;

    function aditionalInformation() {
        if (! empty($additional_information) && is_array($additional_information)) {
            foreach ($additional_information as $info_name => $info_value) {
                ?>
                    <strong><?= esc_attr(Sibs2\sibsGeneralFunctions::sibs_translate_additional_information($info_name)) ?>: </strong>
                    <?= esc_attr($info_value) ?> <br/>
                <?php
            }
        }
    }
?>
<div class="sibs_payment_information">
	<h3>
		<?= esc_attr(__('Payment Information', Sibs2\sibsConstants::SIBS_TRANSLATE)) ?>
	</h3>
	<div class="information">
		<p>
			<strong><?= esc_attr(__('Payment Method', Sibs2\sibsConstants::SIBS_TRANSLATE)) ?>: </strong>
            <?= esc_attr(Sibs2\sibsGeneralFunctions::sibs_translate_backend_payment($transaction_log['payment_id'] ?? '')) ?> <br/>

            <strong><?= esc_attr(__('Transaction ID', Sibs2\sibsConstants::SIBS_TRANSLATE)) ?>: </strong>
            <?= esc_attr($transaction_log['reference_id'] ?? '') ?> <br/>

            <strong><?= esc_attr(__('Currency', Sibs2\sibsConstants::SIBS_TRANSLATE)) ?>: </strong>
            <?= esc_attr($transaction_log['currency'] ?? '') ?> <br/>

            <strong><?= esc_attr(__('Amount', Sibs2\sibsConstants::SIBS_TRANSLATE)) ?>: </strong>
            <?= esc_attr($transaction_log['amount'] ?? '') ?> <br/>

            <?= aditionalInformation() ?>
		</p>
	</div>
</div>