<?php
defined( 'ABSPATH' ) || exit;

if (! empty($settings['payment_brand']) && in_array($payment_parameters['payment_brand'], ['BLIK', 'PBLKV'])) {
    ?>
    	<p><?= __('Keep your phone close by as it will be necessary to complete the payment.', Sibs2\sibsConstants::SIBS_TRANSLATE) ?></p>";
	<?php
}

$isloggin = false;

if (is_user_logged_in()) {
    $isloggin = true;
}
?>

<div class="spg_loading">
	<div class="spg_loading_inner">
		<div class="spg_spinner" aria-hidden="true"></div>
		<div role="status" aria-live="polite" class="spg_loading_text">
			<?= __('Getting everything ready...<br>Please wait and don’t refresh the browser.', Sibs2\sibsConstants::SIBS_TRANSLATE) ?>
		</div>
	</div>
</div>

<form
	class="paymentSPG"
	spg-context="<?= esc_attr($formContext); ?>"
	spg-config="<?= esc_attr($formConfig); ?>"
	spg-signature="<?= esc_attr($signature); ?>"
	spg-style="<?= esc_attr($spg_style); ?>"
>
</form>