<?php

/**
 * Sibs Payments Form.
 *
 * The file is for displaying the Sibs register form
 * Copyright (c) SIBS
 *
 * @located at  /template/ckeckout/
 */
defined( 'ABSPATH' ) || exit;

?>
<?php if ($payment_id === 'sibs_stg_paypalsaved') : ?>

	<style>
		body,
		button.wpwl-button-brand {
			display: none;
		}
	</style>
	<script type="text/javascript">
		var wpwlOptions = {
			onReady: function() {
				jQuery(".wpwl-form").submit();
			}
		}
	</script>
	<input type="submit" value="Submit" style="display:none" />

<?php else: ?>

	<h2 class="header-title header-center"><?php echo esc_attr($form_title); ?></h2>
	<script type="text/javascript">
		var wpwlOptions = {
			locale: "<?php echo esc_attr(strtolower(substr(get_bloginfo('language'), 0, 2))); ?>",
			style: "card",
			onReady: function() {
				var buttonCancel = "<a href='<?php echo esc_attr($url_config['cancel_url']); ?>' class='wpwl-button btn_cancel'><?php echo esc_attr(__('Cancel', Sibs2\sibsConstants::SIBS_TRANSLATE)); ?></a>";
				var buttonConfirm = "<?php echo esc_attr($confirm_button); ?></a>";
				var ttTestMode = "<div class='testmode'><?php echo esc_attr(__('THIS IS A TEST. NO REAL MONEY WILL BE TRANSFERRED', Sibs2\sibsConstants::SIBS_TRANSLATE)); ?></div>";
				var ttRegistration = "<div class='register-tooltip'><?php echo esc_attr(sprintf(__('A small amount (<1 %s) will be charged and instantly refunded to verify your account/card details', Sibs2\sibsConstants::SIBS_TRANSLATE), "EUR")); ?></div>";
				jQuery("form.wpwl-form").find(".wpwl-button").before(buttonCancel);
				jQuery(".wpwl-button-pay").html(buttonConfirm);
				jQuery(".wpwl-container").after(ttRegistration);
				<?php if ('TEST' === $register_parameters['server_mode']) : ?>
					jQuery(".wpwl-container").wrap("<div class='frametest'></div>");
					jQuery('.wpwl-container').before(ttTestMode);
				<?php endif; ?>
			},
			registrations: {
				hideInitialPaymentForms: false,
				requireCvv: false
			}
		}
	</script>
<?php endif; ?>

<form action="<?php echo esc_attr($url_config['return_url']); ?>" class="paymentWidgets"><?php echo esc_attr($payment_brand); ?></form>