# === StarGate Payment Gateway for WooCommerce ===
Contributors: comprassibs
Tags: payments, woocommerce, blik, pay by link, sibs, credit card, visa, mastercard, payment gateway, apple pay, google pay
Stable tag: 2.2.3
Requires at least PHP: 7.4 (with sodium or open ssl)
Prestashop tested up to: 8.3.x
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html

Accept VISA, MasterCard, BLIK and Pay By Link with a single payment gateway solution.

# == Description ==

A ready-to-service e-commerce solution, with integrated checkout positioning and BackOffice for merchant management. An interface for various national and international payment methods.

*Why use SIBS Payments Gateway for WooCommerce?*

- Unique platform for payment methods and brands relevant to your customers, with PCI DSS security certification.
- Fraud prevention and detection in every channel and cards in the system.
- Web responsive hosted SIBS payment page allowing you not to process sensitive data.
- Allows the Acquirer choice for each payment method.
- From the authenticated registration, SIBS keep the card sensitive data, allowing One Click Shopping experience.
- Supports 3D Secure.
- And more!

*Integrated Checkout*

SIBS Payments Gateway Plugin for WooCommerce allows you to have an integrated checkout on your Web page, ensuring a good customer experience and better conversion rates.
Through COPYandPAY payment form direct integration in the shopping cart, you offer different payment methods to the customer in a safe way. 

*Monitoring and reporting tools*

The BackOffice allows you to view an activity summary in the entry page with given modules and configurable indicators, consult the transaction list with real time state updates, verify the transaction detail, act on a transaction (amount capture, transaction canceling and amount refund), activity monitoring through configurable reports (by period, payment method, operation type, etc...) and export visualized data or aggregated reports.

*Better Fraud protection*

*Integrated with the domestic banking system*

Integrated with national issuers, processing and in the interbank clearing system.

*Warranty*

The plugin is provided “as is” without warranty of any kind, expressed or implied. We shall not be liable for any damages, including but not limited to, direct, indirect, special, incidental or consequential damages or losses that occur out of the use or inability to use our products or support.
Before general release, the plugins are tested and guaranteed to function on basic installation of Wordpress and regular Woocommerce. We do not, and cannot, assure that that it will function with all third-party plugins or in all web browsers, therefore, we cannot be held responsible for any conflicts that may occur in your installation. 
It is our policy to support our plugins as best we can and we will provide support for third-party plugin conflicts at our discretion or as time allows. 
We are not responsible for any data loss or other damages that may occur as a result of installing our plugins.

*Acceptance*

By using the plugin you indicate that you have read and agreed and understood the terms above.
We reserve the right to change or modify the current terms.

# == Installation ==

In order to have the solution ready to use:

1.	Separately from the plugin installation you will need an agreement with the available Financial Institutions:
    - Caixa Geral de Depósitos
    - Millennium BCP
    - Santander
    - Banco BPI
    - Caixa Crédito Agrícola
    - SIBS Pagamentos
    - Others 
2.	Once the agreement is signed with the chosen Financial Institution, you can request your credentials to start accepting payments.
3.	Please contact SIBS to proceed:
    - Email - pagamentos@sibs.pt, paymentservices@sibs.pt
    - Phone - 217918703

# == Frequently Asked Questions ==

*Where can I find documentation?*

For help setting up and configuring, please refer to our user guide.

*How long does it take to start accepting payments?*

After the agreement is signed and the plugin is run to integrate the solution, enter the credentials to start accepting payments.

*What currencies can I use?*

Currently, only Euros.

*How long does it take the money to get to my account?*

The money will be deposited directly in your bank account (there are no wallets in the middle of the process) accordingly to the Bank clearing and settlement cycles.

# == Changelog ==

## v1.0.24
*Released on*
- 2022/11/03

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Removed override classes
- Added hooks to do the override removed functions
- Made plugin more compatible with other third party plugins


## v1.0.25
*Released on*
- 2022/11/25

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Made the First code reformulation
- Added Pay By Link Kevin Method


## v1.0.30
*Released on*
- 2023/01/12

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Made the Second code reformulation
- Fixed FormStyle
- Added First OneClick MVP
- Added OneClick Customer Acceptance
- Added Polsky Translations
- Added Form Style in Default Layout


## v1.0.31
*Released on*
- 2023/04/14

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Updated str_contains that only works on PHP 8 to SibsUtils::strContains that works on php 7.X too


## v1.0.32
*Released on*
- 2023/04/14

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Added in composer symfony/polyfill-php74
- Added in composer symfony/polyfill-php80
- Added in composer symfony/polyfill-php81
- Added in composer symfony/polyfill-php82
- Added in composer symfony/polyfill-php83


## v1.1.0
*Released on*
- 2023/05/15

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Added SIBS Transaction ID on admin order page
- Added Loader and Confirmation popup when Capturing and Refunding a payment
- Changed the Oneclick Terms and Conditions View from page to modal
- Added Partial Refund Button Implementation
- Added the sibs payment module in the payments admin page
- Removed override address form validation file
- Added address form validation file to a prestashop hook function
- Improved sibs payment details to Order Page Admin View
- Added polyfill for older php
- Added Loading feedback for form


## v1.1.1
*Released on*
- 2023/05/20

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Fixed Webhook/log input error on client address form
- Added More translations


## v1.1.2
*Released on*
- 2023/05/22

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Fixed Undefined variable: translated_message
- Added untranslated messages
- Resolved the page SIBS terms of service was not found
- Added missing labels of Blik and PBL


## v1.1.3
*Released on*
- 2023/05/25

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Fixed Credit Card label
- Changed Icons positions


## v1.1.4
*Released on*
- 2023/05/26

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Fixed capture, refund and inquiry cancel frontend functions


## v1.1.5
*Released on*
- 2023/05/29

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- Fixed problem that shows Save card option even when user is not logged



## v1.1.6
*Released on*
- 2023/07/19

*Stability*
- PHP: 7.2 to 7.4
- Prestashop: 1.7.6 to 1.7.8.8

*Changes*
- STARG-3422 - Removed Privacy Policy warning on installation
- Removed inputs not used

## v1.1.7
*Released on*
- 2023/11/17

*Stability*
- PHP: 7.4 to 8.1
- Prestashop: 1.7.6 to 8.1.0

*Changes*
- Updated plugin compliancy to work o prestashop 8
- Remover unused hook that has an error on first install the plugin

## v2.0.0
*Released on*
- 2024/03/12

*Stability*
- PHP: 7.4 to 8.1
- Prestashop: 1.7.6 to 8.1.0

*Changes*
- Added Xpay (Apple pay and Google pay)
- Fixed Multi transactionID to one merchantTransactionID problem
- Added Dutch Translation

## v2.0.1
*Released on*
- 2024/05/20

*Stability*
- PHP: 7.4 to 8.1
- Prestashop: 1.7.6 to 8.1.0

*Changes*
- Fixed when selecting the "Cards" payment method, BLIK not appears anymore
- Fixed abandoned payments that was paid and was shown as abandoned carts
- Added Log Files

## v2.0.2
*Released on*
- 2024/05/23

*Stability*
- PHP: 7.4 to 8.1
- Prestashop: 1.7.6 to 8.1.6

*Changes*
- Implementation of webhook retry request

## v2.0.3
*Released on*
- 2024/06/12

*Stability*
- PHP: 7.4 to 8.1
- Prestashop: 1.7.6 to 8.1.6

*Changes*
- Validate creation of tables to assure they exist when client is transactioning

## v2.1.0
*Released on*
- 2024/08/14

*Stability*
- PHP: 7.4 to 8.2
- Prestashop: 1.7.6 to 8.1.7

*Changes*
- Improved Data Table creation
- Fixed Translations
- Added Open SSL to webhook decrypt

## v2.2.0
*Released on*
- 2024/10/02

*Stability*
- PHP: 7.4 to 8.2
- Prestashop: 1.7.6 to 8.1.7

*Changes*
- Removed deprecated Pay By Link fields
- Added Pay By Link Autopay

## v2.2.1
*Released on*
- 2024/10/17

*Stability*
- PHP: 7.4 to 8.2
- Prestashop: 1.7.6 to 8.1.7

*Changes*
- Fixed Autopay Validation Date Link

## v2.2.2
*Released on*
- 2024/10/29

*Stability*
- PHP: 7.4 to 8.2
- Prestashop: 1.7.6 to 8.1.7

*Changes*
- Fixed Translations

## v2.2.3
*Released on*
- 2026/01/19

*Stability*
- PHP: 7.4 to 8.3
- Prestashop: 1.7.6 to 8.1.7

*Changes*
- Fixed Error messages
- Fixed SSL requests