<?php
/** to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0  Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */
class SibsOneclickTermsModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        $pdf        = $this->getOneclickPDFTermsByLanguage();
        $siteUrl    = str_replace('/shop', '', (Tools::getHttpHost(true) . __PS_BASE_URI__));
        $pdfMedia   = "modules/sibs/views/files/$pdf";
        $embedMedia = "https://drive.google.com/viewerng/viewer?embedded=true&url={$siteUrl}{$pdfMedia}";

        $this->context->smarty->assign([
            'embedMedia' => $embedMedia,
        ]);

        parent::initContent();
        $this->setTemplate('module:sibs/views/templates/front/oneclickTerms.tpl');
    }

    public function getOneclickPDFTermsByLanguage()
    {
        // Update from: https://www.pay.sibs.com/eng/documentation/sibs-gateway-3/files/20220713_End%20customer%20regulations%20PL_KK_PS_PDF.pdf/
        // Update from: https://www.pay.sibs.com/eng/documentation/sibs-gateway-3/files/20220713_End%20customer%20regulations%20PL_KK_PS%20en-US_PDF.pdf/

        $iso_code = Context::getContext()->language->iso_code;

        switch($iso_code) {
            case 'pl':
            case 'en':
                return "sibs_terms_and_conditions_{$iso_code}.pdf";

                break;
            default:
                return 'sibs_terms_and_conditions_en.pdf';
        }
    }
}
