<?php
/**
 * 2007-2019 PrestaShop and Contributors.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/OSL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/OSL-3.0 Open Software License (OSL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 */
class CustomerAddressForm extends CustomerAddressFormCore
{
    public function validate()
    {
        // Deprecation

        $module = Module::getInstanceByName('sibs');

        $is_valid = true;
        $postcode = $this->getField('postcode');

        if (! empty($postcode)) {
            if ($postcode->isRequired()) {
                $country = $this->formatter->getCountry();

                if (! $country->checkZipCode($postcode->getValue())) {
                    $postcode->addError($this->translator->trans(
                        'Invalid postcode - should look like "%zipcode%"',
                        ['%zipcode%' => $country->zip_code_format],
                        'Shop.Forms.Errors'
                    ));
                    $is_valid = false;
                }
            }
        }

        $address1       = $this->getField('address1');
        $address2       = $this->getField('address2');
        $address1_chars = strlen($this->getValue('address1'));
        $address2_chars = strlen($this->getValue('address2'));
        $total_char     = $address1_chars + $address2_chars;

        if ($total_char > 70) {
            $address1->addError($module->l('ERROR_CHARS'));
            $address2->addError($module->l('ERROR_CHARS'));
        }

        $hookReturn = Hook::exec('actionValidateCustomerAddressForm', ['form' => $this]);

        if ($hookReturn !== '') {
            $is_valid &= (bool) $hookReturn;
        }

        return $is_valid && parent::validate();
    }
}
