<?php

namespace Sibs\DB;

use Exception;
use Sibs\Models\SibsCardTokens;
use Sibs\Models\SibsOrderRef;
use Sibs\Models\SibsOrderRefLog;
use Sibs\Models\SibsTerminal;
use Sibs\Models\SibsTransaction;
use Sibs\Models\SibsWebhookCalls;
use Sibs\SibsLogger;

class SibsSeeder
{
    private const TABLE_METHOD = 'getStaticTableName';
    private const SEED_METHOD  = 'seed';

    /**
     * Execute Seeder.
     *
     * @return bool
     */
    public static function execute(): bool
    {
        return
            self::seedClass(SibsOrderRef::class) &&
            self::seedClass(SibsOrderRefLog::class) &&
            self::seedClass(SibsCardTokens::class) &&
            self::seedClass(SibsTerminal::class) &&
            self::seedClass(SibsWebhookCalls::class) &&
            self::seedClass(SibsTransaction::class);
    }

    /**
     * Seed Class.
     *
     * @param string $tableClass
     * @return bool
     */
    private static function seedClass($tableClass): bool
    {
        $tableName = call_user_func_array([$tableClass, self::TABLE_METHOD], []);

        try {
            SibsLogger::info('Seeding ' . $tableName . ' table');

            $response = call_user_func_array([$tableClass, self::SEED_METHOD], []);

            if ($response == false) {
                throw new Exception('General Error');
            }

            SibsLogger::info('Seeded ' . $tableName . ' table');

            return true;
        } catch (Exception $e) {
            SibsLogger::error('Error on Seeding ' . $tableName . ' table: ' . $e->getMessage());

            return false;
        }
    }
}
