<?php

namespace Sibs\Models;

use Db;

class PrestashopModule extends SibsModels
{
    /**
     * Get Static Table Name.
     *
     * @return bool
     */
    public static function getStaticTableName(): string
    {
        return _DB_PREFIX_ . 'module';
    }

    /**
     * Get Static Config Name.
     *
     * @return bool
     */
    public static function getStaticConfigName(): string
    {
        return '';
    }

    /**
     * Create Model.
     *
     * @return bool
     */
    public static function create(): bool
    {
        return true;
    }

    /**
     * Seed Model.
     *
     * @return bool
     */
    public static function seed(): bool
    {
        return true;
    }

    /**
     * Is Plugin Version Updated.
     *
     * @param string $actual_version
     * @return bool
     */
    public static function isPluginVersionUpdated($actual_version)
    {
        $table = self::getStaticTableName();

        $sqlString = "SELECT `version`
            FROM `{$table}`
            WHERE `name` = 'sibs' ";

        $version = Db::getInstance()->getValue($sqlString);

        if (! empty($version) && $version != $actual_version) {
            return false;
        }

        return true;
    }

    /**
     * Update Plugin Version.
     *
     * @param string $actual_version
     * @param string $module_name
     * @return bool
     */
    public static function updatePluginVersion($actual_version, $module_name)
    {
        $table = self::getStaticTableName();

        $sql = "UPDATE `{$table}`
            SET `version` = '{$actual_version}'
            WHERE `name` = '{$module_name}' ";

        return Db::getInstance()->execute($sql);
    }
}
