<?php

namespace Sibs\Models;

use Sibs\DB\Seeds\Version_2_1_0\SibsOrderRefLogSeed_2_1_0;

class SibsOrderRefLog extends SibsModels
{
    /**
     * SIBS Order ID.
     *
     * @var int
     */
    public $id_order;

    /**
     * SIBS Transaction ID.
     *
     * @var int
     */
    public $id_transaction;

    /**
     * Reference ID.
     *
     * @var int
     */
    public $id_reference;

    /**
     * Capture ID.
     *
     * @var int
     */
    public $id_captured;

    /**
     * Refund ID.
     *
     * @var int
     */
    public $id_refunded;

    /**
     * Payment Method.
     *
     * @var string
     */
    public $payment_method;

    /**
     * Payment Type.
     *
     * @var string
     */
    public $payment_type;

    /**
     * Payment Status.
     *
     * @var string
     */
    public $payment_status;

    /**
     * Payment Date.
     *
     * @var string
     */
    public $payment_date;

    /**
     * Currency.
     *
     * @var string
     */
    public $currency;

    /**
     * Amount.
     *
     * @var string
     */
    public $amount;

    /**
     * Capture Status.
     *
     * @var string
     */
    public $capture_status;

    /**
     * Capture Information.
     *
     * @var string
     */
    public $capture_information;

    /**
     * Refund Status.
     *
     * @var string
     */
    public $refund_status;

    /**
     * Refund Information.
     *
     * @var string
     */
    public $refund_information;

    /**
     * Definition.
     *
     * @var array
     */
    public static $definition = [
        'table'     => 'sibs_order_ref_log',
        'primary'   => 'id',
        'multilang' => false,
        'fields'    => [
            'id_order'            => ['type' => self::TYPE_INT, 'validate' => 'isNullOrUnsignedId', 'size' => 10],
            'id_transaction'      => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 32],
            'id_reference'        => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 32],
            'id_captured'         => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 32],
            'id_refunded'         => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 32],
            'payment_method'      => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 50],
            'payment_type'        => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 50],
            'payment_status'      => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 50],
            'payment_date'        => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
            'currency'            => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 3],
            'amount'              => ['type' => self::TYPE_FLOAT, 'validate' => 'isFloat'],
            'capture_status'      => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 50],
            'capture_information' => ['type' => self::TYPE_NOTHING, 'validate' => 'isGenericName'],
            'refund_status'       => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 50],
            'refund_information'  => ['type' => self::TYPE_NOTHING, 'validate' => 'isGenericName'],
        ],
    ];

    /**
     * Get Static Table Name.
     *
     * @return bool
     */
    public static function getStaticTableName(): string
    {
        return _DB_PREFIX_ . self::$definition['table'];
    }

    /**
     * Get Static Config Name.
     *
     * @return bool
     */
    public static function getStaticConfigName(): string
    {
        return 'CREATE_SIBS_ORDER_REF_LOG_TABLE';
    }

    /**
     * Create Model.
     *
     * @return bool
     */
    public static function create(): bool
    {
        $table      = self::getStaticTableName();
        $orderTable = _DB_PREFIX_ . 'orders';

        $sql = "CREATE TABLE IF NOT EXISTS `{$table}`(
            `id` INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `id_order` INT(10) UNSIGNED NULL,
            `id_transaction` VARCHAR(32) NOT NULL,
            `id_reference` VARCHAR(32) NOT NULL,
            `id_captured` VARCHAR(32) NULL,
            `id_refunded` VARCHAR(32) NULL,
            `payment_method` VARCHAR(50) NOT NULL,
            `payment_type` VARCHAR(50),
            `payment_status` VARCHAR(50) NOT NULL,
            `payment_date` DATE NOT NULL,
            `currency` VARCHAR(3) NOT NULL,
            `amount` decimal(17,2) NOT NULL,
            `capture_status` VARCHAR(50) NULL,
            `capture_information` LONGTEXT NULL,
            `refund_status` VARCHAR(50) NULL,
            `refund_information` LONGTEXT NULL,
            FOREIGN KEY (`id_order`) REFERENCES `{$orderTable}`(`id_order`)
        )";

        return \Db::getInstance()->Execute($sql);
    }

    /**
     * Seed Model.
     *
     * @return bool
     */
    public static function seed(): bool
    {
        $self = new self();

        return
            SibsOrderRefLogSeed_2_1_0::seed($self);
    }

    /**
     * Get Order SIBS Log.
     *
     * @param int $id
     * @return array
     */
    public static function getOrderSibsLogger($id)
    {
        $table = self::getStaticTableName();

        $query = "SELECT *
            FROM `{$table}`
            WHERE `id_order` = '$id' ORDER BY id DESC ";

        return \Db::getInstance()->ExecuteS($query);
    }

    /**
     * Save Transaction Refund Log.
     *
     * @param int $cartID
     * @param string $paymentMethod
     * @param array $resultJson
     * @return bool
     */
    public static function saveTransactionRefundLog($cartID, $paymentMethod, $resultJson)
    {
        $date = date('ymd');

        $orderID        = $cartID;
        $id_cart        = $date . $cartID;
        $id_transaction = $resultJson['transactionID'];
        $paymentType    = $resultJson['paymentType'];
        $paymentStatus  = $resultJson['paymentStatus'];
        $currency       = $resultJson['amount']['currency'];
        $value          = $resultJson['amount']['value'];

        $table = self::getStaticTableName();

        $sql = "INSERT INTO `{$table}` (
            `id_transaction`, `id_reference`, `payment_method`,
            `payment_type`, `payment_status`, `currency`, `amount`,
            `payment_date`,`id_order`
        ) VALUES (
            '$id_transaction', '$id_cart', '$paymentMethod',
            '$paymentType', '$paymentStatus', '$currency', '$value',
            '$date', '$orderID'
        ) ";

        return \Db::getInstance()->execute($sql);
    }
}
