<?php

namespace Sibs\Models;

use Db;
use Sibs\DB\Seeds\Version_2_1_0\SibsTerminalSeed_2_1_0;

class SibsTerminal extends SibsModels
{
    /**
     * SIBS Terminal Code.
     *
     * @var int
     */
    public $terminal_code;

    /**
     * SIBS Bearer Token.
     *
     * @var string
     */
    public $bearer_token;

    /**
     * SIBS Client ID.
     *
     * @var string
     */
    public $client_id;

    /**
     * SIBS Webhook.
     *
     * @var string
     */
    public $webhook;

    /**
     * SIBS environment.
     *
     * @var string
     */
    public $environment;

    /**
     * SIBS currency.
     *
     * @var string
     */
    public $currency;

    /**
     * Definition.
     *
     * @var array
     */
    public static $definition = [
        'table'     => 'sibs_terminal',
        'primary'   => 'id',
        'multilang' => false,
        'fields'    => [
            'terminal_code'            => ['type' => self::TYPE_INT, 'validate' => 'isNullOrUnsignedId', 'size' => 10],
            'bearer_token'             => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 200],
            'client_id'                => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 32],
            'webhook'                  => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 500],
            'environment'              => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 50],
            'currency'                 => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 50],

        ],
    ];

    /**
     * Get Static Table Name.
     *
     * @return bool
     */
    public static function getStaticTableName(): string
    {
        return _DB_PREFIX_ . self::$definition['table'];
    }

    /**
     * Get Static Config Name.
     *
     * @return bool
     */
    public static function getStaticConfigName(): string
    {
        return 'CREATE_SIBS_TERMINAL_TABLE';
    }

    /**
     * Create Model.
     *
     * @return bool
     */
    public static function create(): bool
    {
        $table = self::getStaticTableName();

        $sql = "CREATE TABLE IF NOT EXISTS `{$table}`(
            `id` INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `terminal_code` INT(10) UNSIGNED NULL,
            `bearer_token` LONGTEXT NULL,
            `client_id` LONGTEXT NULL,
            `webhook` LONGTEXT NULL,
            `environment` VARCHAR(32) NULL,
            `currency` VARCHAR(50) NULL,
            UNIQUE KEY `id_terminal_code_key` (`terminal_code`)
        )";

        return Db::getInstance()->Execute($sql);
    }

    /**
     * Seed Model.
     *
     * @return bool
     */
    public static function seed(): bool
    {
        $self = new self();

        return
            SibsTerminalSeed_2_1_0::seed($self);
    }

    /**
     * Get Terminal SIBS.
     *
     * @return array
     */
    public static function getTerminalSibs()
    {
        $table = self::getStaticTableName();

        $query = "SELECT * FROM `{$table}` ";

        return Db::getInstance()->ExecuteS($query);
    }

    /**
     * Get Terminal SIBS View.
     *
     * @param int $id
     * @return array
     */
    public static function getTerminalSibsView($id)
    {
        $table = self::getStaticTableName();

        $query = "SELECT *
            FROM `{$table}`
            WHERE `id` = '$id' ";

        return Db::getInstance()->getRow($query);
    }

    /**
     * Update Terminal SIBS.
     *
     * @param int $ID
     * @param string $params
     * @param string $value
     * @return bool
     */
    public static function updateTerminalSibs($ID, $param, $value)
    {
        $table = self::getStaticTableName();

        $sql = "UPDATE `{$table}`
            SET `{$param}` = '$value'
            WHERE `id` = $ID ";

        return Db::getInstance()->execute($sql);
    }

    /**
     * Save Terminal.
     *
     * @param array $resultJson
     * @return bool
     */
    public static function saveTerminal($resultJson)
    {
        $terminal_code  = $resultJson['terminal_code'];
        $bearer_token   = $resultJson['bearer_token'];
        $client_id      = $resultJson['client_id'];
        $currency       = $resultJson['currency'];
        $environment    = $resultJson['environment'];
        $webhook        = $resultJson['webhook'];

        $table = self::getStaticTableName();

        $sql = "INSERT INTO `{$table}` (
            `terminal_code`, `bearer_token`, `client_id`, `currency`, `environment`, `webhook`
        ) VALUES (
            '$terminal_code', '$bearer_token', '$client_id', '$currency', '$environment', '$webhook'
        ) ";

        return Db::getInstance()->execute($sql);
    }
}
