<?php

namespace Sibs\Models;

use Db;
use Sibs\DB\Seeds\Version_2_1_0\SibsTransactionSeed_2_1_0;

class SibsTransaction extends SibsModels
{
    /**
     * Order ID.
     *
     * @var int
     */
    public $id_order;

    /**
     * Cart ID.
     *
     * @var string
     */
    public $cart_id;

    /**
     * Order ID.
     *
     * @var string
     */
    public $order_id;

    /**
     * Transaction ID.
     *
     * @var string
     */
    public $id_transaction;

    /**
     * Form Config.
     *
     * @var string
     */
    public $formConfig;

    /**
     * Form Context.
     *
     * @var string
     */
    public $formContext;

    /**
     * Signature.
     *
     * @var string
     */
    public $signature;

    /**
     * SPG Style.
     *
     * @var string
     */
    public $spg_style;

    /**
     * Payment Date.
     *
     * @var Date
     */
    public $payment_date;

    /**
     * Amount.
     *
     * @var float
     */
    public $amount;
    /**
     * Definition.
     *
     * @var array
     */
    public static $definition = [
        'table'     => 'sibs_transaction',
        'primary'   => 'id',
        'multilang' => false,
        'fields'    => [
            'id_order'            => ['type' => self::TYPE_INT, 'validate' => 'isNullOrUnsignedId', 'size' => 10],
            'cart_id'             => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 60],
            'order_id'            => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 60],
            'id_transaction'      => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 255],
            'formConfig'          => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName'],
            'formContext'         => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName'],
            'signature'           => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName'],
            'spg_style'           => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 32],
            'payment_date'        => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
            'amount'              => ['type' => self::TYPE_FLOAT, 'validate' => 'isPrice'],
        ],
    ];

    /**
     * Get Static Table Name.
     *
     * @return bool
     */
    public static function getStaticTableName(): string
    {
        return _DB_PREFIX_ . self::$definition['table'];
    }

    /**
     * Get Static Config Name.
     *
     * @return bool
     */
    public static function getStaticConfigName(): string
    {
        return 'CREATE_SIBS_TRANSACTION_TABLE';
    }

    /**
     * Create Model.
     *
     * @return bool
     */
    public static function create(): bool
    {
        $table = self::getStaticTableName();

        $sql = "CREATE TABLE IF NOT EXISTS `{$table}`(
            `id` INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `id_order` INT(10) UNSIGNED NULL,
            `order_id` VARCHAR(60) NULL,
            `cart_id` VARCHAR(60) NULL,
            `id_transaction` VARCHAR(255) NULL,
            `formConfig` LONGTEXT NULL,
            `formContext` LONGTEXT NULL,
            `signature` LONGTEXT NULL,
            `spg_style` VARCHAR(32) NULL,
            `payment_date` DATE NOT NULL,
            `amount` decimal(17,2) NOT NULL
        )";

        return Db::getInstance()->Execute($sql);
    }

    /**
     * Seed Model.
     *
     * @return bool
     */
    public static function seed(): bool
    {
        $self = new self();

        return
            SibsTransactionSeed_2_1_0::seed($self);
    }

    /**
     * Get Transactions SIBS View.
     *
     * @param int $transactionID
     * @param float $amount
     * @return array
     */
    public static function getTransactionsSibsView($transactionID, $amount)
    {
        $table = self::getStaticTableName();

        $query = "SELECT *
            FROM `{$table}`
                WHERE `id_order` = '$transactionID' AND `amount` = '$amount'";

        return Db::getInstance()->getRow($query);
    }

    /**
     * Get Cart ID by Custom Attribute.
     *
     * @param string $originalTransactionId
     * @param string $attributeIdField
     * @return array
     */
    public static function getCartIdByCustomAttribute($originalTransactionId, $attributeIdField = 'id_transaction')
    {
        $table = self::getStaticTableName();

        $sqlString = "SELECT * FROM `{$table}` WHERE `$attributeIdField` = '$originalTransactionId' ";

        return Db::getInstance()->getRow($sqlString);
    }

    /**
     * Save Transactions SIBS.
     *
     * @param int $transactionID
     * @param array $resultJson
     * @return bool
     */
    public static function saveTransactionsSibs($transactionID, $resultJson)
    {
        $cart_id           = $transactionID;
        $id_transaction    = $resultJson['transactionID'];
        $formConfig        = $resultJson['formConfig'] ?? null;
        $formContext       = $resultJson['formContext'];
        $signature         = $resultJson['transactionSignature'];
        $spg_style         = $resultJson['spg_style'] ?? null;
        $amount            = $resultJson['amount']['value'] ?? null;
        $payment_date      = date('Y-m-d');

        $table = self::getStaticTableName();

        $sql = "INSERT INTO `{$table}` (
            `cart_id`, `id_transaction`, `formConfig`, `formContext`, `signature`, `spg_style`, `payment_date`, `amount`
        ) VALUES (
            '$cart_id', '$id_transaction', '$formConfig', '$formContext', '$signature', '$spg_style','$payment_date', '$amount'
        )";

        return Db::getInstance()->execute($sql);
    }

    /**
     * Delete Transactions SIBS.
     *
     * @param int $transactionID
     * @return bool
     */
    public static function deleteTransactionsSibs($transactionID)
    {
        $table = self::getStaticTableName();

        $sql = "DELETE FROM `{$table}` WHERE `id_transaction` = '$transactionID'";

        return Db::getInstance()->execute($sql);
    }
}
