<?php

namespace Sibs\Models;

use Db;
use Sibs\DB\Seeds\Version_2_1_0\SibsWebhookCallsSeed_2_1_0;

class SibsWebhookCalls extends SibsModels
{
    /**
     * SIBS Terminal Code.
     *
     * @var int
     */
    public $terminal_code;

    /**
     * SIBS Bearer Token.
     *
     * @var string
     */
    public $bearer_token;

    /**
     * SIBS Client ID.
     *
     * @var string
     */
    public $client_id;

    /**
     * SIBS Webhook.
     *
     * @var string
     */
    public $webhook;

    /**
     * SIBS environment.
     *
     * @var string
     */
    public $environment;

    /**
     * SIBS currency.
     *
     * @var string
     */
    public $currency;

    /**
     * Definition.
     *
     * @var array
     */
    public static $definition = [
        'table'     => 'sibs_webhook_calls',
        'primary'   => 'id',
        'multilang' => false,
        'fields'    => [
            'notification_id'  => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 127],
            'url'              => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'size' => 255],
            'headers'          => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName'],
            'payload'          => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName'],
            'decoded_payload'  => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName'],
            'exception'        => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName'],
            'arrived'          => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'size' => 50],
            'processed_qty'    => ['type' => self::TYPE_INT, 'validate' => 'isInt', 'size' => 50],
            'processed_at'     => ['type' => self::TYPE_DATE, 'isDate' => 'isGenericName', 'size' => 50],
            'created_at'       => ['type' => self::TYPE_DATE, 'isDate' => 'isGenericName', 'size' => 50],
        ],
    ];

    /**
     * Get Static Table Name.
     *
     * @return bool
     */
    public static function getStaticTableName(): string
    {
        return _DB_PREFIX_ . self::$definition['table'];
    }

    /**
     * Get Static Config Name.
     *
     * @return bool
     */
    public static function getStaticConfigName(): string
    {
        return 'CREATE_SIBS_WEBHOOK_CALLS_TABLE';
    }

    /**
     * Create Model.
     *
     * @return bool
     */
    public static function create(): bool
    {
        $table = self::getStaticTableName();

        $sql = "CREATE TABLE IF NOT EXISTS `{$table}`(
            `id` INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `notification_id` VARCHAR(127) NULL,
            `url` VARCHAR(255) NULL,
            `headers` LONGTEXT NULL,
            `payload` LONGTEXT NULL,
            `decoded_payload` LONGTEXT NULL,
            `exception` LONGTEXT NULL,
            `arrived` INT(10) UNSIGNED NULL,
            `processed_qty` INT(10) UNSIGNED NULL,
            `processed_at` DATETIME NULL,
            `created_at` DATETIME NOT NULL,
            UNIQUE KEY `id_notification_id_key` (`notification_id`)
        )";

        return Db::getInstance()->execute($sql);
    }

    /**
     * Seed Model.
     *
     * @return bool
     */
    public static function seed(): bool
    {
        $self = new self();

        return
            SibsWebhookCallsSeed_2_1_0::seed($self);
    }
}
