<?php

namespace Sibs;

class SibsConstants
{
    // Sibs Plugin Informations
    const SIBS_PLUGIN_VESION    = '2.2.3';
    const SIBS_PLUGIN_NAME      = 'sibs';
    const SIBS_PLUGIN_TAB       = 'payments_gateways';
    const SIBS_PLUGIN_AUTHOR    = 'SIBS';
    const SIBS_PLUGIN_BOOTSTRAP = true;
    const SIBS_DISPLAY_NAME     = 'SIBS';
    const SIBS_SHOP_SYSTEM      = 'SIBS';
    const SIBS_MULTCURRENCY     = false;

    // Deprecation and not implemented yet version
    const DEPRECATION_PHP_VERSION                = '7.2'; // https://www.php.net/releases/index.php
    const DEPRECATION_PRESTASHOP_VERSION         = '1.7.7';
    const NOT_IMPLEMENTED_YET_PRESTASHOP_VERSION = '9.1.0';

    const SIBS_PRESTASHOP_VERSION_COMPLIANCY = [
        'min' => self::DEPRECATION_PRESTASHOP_VERSION,
        'max' => self::NOT_IMPLEMENTED_YET_PRESTASHOP_VERSION,
    ];

    // Payment Methods
    const PAYMENT_METHOD_CARD              = 'CARD';
    const PAYMENT_METHOD_CREDIT_CARD       = 'CC';
    const PAYMENT_METHOD_BLIK              = 'BLIK';
    const PAYMENT_METHOD_PAY_BY_LINK       = 'PAY_BY_LINK';
    const PAYMENT_METHOD_PAY_BY_LINK_KEVIN = 'PBLKV';
    const PAYMENT_METHOD_TOKEN             = 'TOKEN';
    const PAYMENT_METHOD_XPAY              = 'XPAY';

    // Payment Mode
    const PAYMENT_MODE_DEBIT       = 'DB';
    const PAYMENT_MODE_AUTH        = 'PA';
    const PAYMENT_MODE_CAPT        = 'CP'; // PA.DB, 'PA.CP'
    const PAYMENT_MODE_RFND        = 'RF';
    const PAYMENT_MODE_RVSL        = 'RV';
    const PAYMENT_MODE_PAY_BY_LINK = 'PBL';
    const PAYMENT_MODE_XPAY        = 'XPAY';

    // Payment Type
    const PAYMENT_TYPE_AUTH  = 'AUTH';
    const PAYMENT_TYPE_PREF  = 'PREF';
    const PAYMENT_TYPE_PURS  = 'PURS';
    const PAYMENT_TYPE_CAPT  = 'CAPT';
    const PAYMENT_TYPE_RFND  = 'RFND';
    const PAYMENT_TYPE_RVSL  = 'RVSL';
    const PAYMENT_TYPE_RCON  = 'RCON';
    const PAYMENT_TYPE_CAUT  = 'CAUT';
    const PAYMENT_TYPE_CPRF  = 'CPRF';
    const PAYMENT_TYPE_STIQ  = 'STIQ';
    const PAYMENT_TYPE_PBL   = 'PBL';
    const PAYMENT_TYPE_XPAY  = 'XPAY';

    // Stargate (SPG) Status
    const PAYMENT_STATUS_SUCCESS      = 'Success';
    const PAYMENT_STATUS_PARTIAL      = 'Partial';
    const PAYMENT_STATUS_INPROCESSING = 'InProcessing';
    const PAYMENT_STATUS_PENDING      = 'Pending';
    const PAYMENT_STATUS_DECLINED     = 'Declined';
    const PAYMENT_STATUS_TIMEOUT      = 'Timeout';
    const PAYMENT_STATUS_ERROR        = 'Error';

    // Prestashop Order Status
    const ORDER_STATUS_CHEQUE            = 'PS_OS_CHEQUE';
    const ORDER_STATUS_PAYMENT           = 'PS_OS_PAYMENT';
    const ORDER_STATUS_PREPARATION       = 'PS_OS_PREPARATION';
    const ORDER_STATUS_SHIPPING          = 'PS_OS_SHIPPING';
    const ORDER_STATUS_DELIVERED         = 'PS_OS_DELIVERED';
    const ORDER_STATUS_CANCELED          = 'PS_OS_CANCELED';
    const ORDER_STATUS_REFUND            = 'PS_OS_REFUND';
    const ORDER_STATUS_ERROR             = 'PS_OS_ERROR';
    const ORDER_STATUS_OUTOFSTOCK        = 'PS_OS_OUTOFSTOCK';
    const ORDER_STATUS_OUTOFSTOCK_PAID   = 'PS_OS_OUTOFSTOCK_PAID';
    const ORDER_STATUS_BANKWIRE          = 'PS_OS_BANKWIRE';
    const ORDER_STATUS_WS_PAYMENT        = 'PS_OS_WS_PAYMENT';
    const ORDER_STATUS_OUTOFSTOCK_UNPAID = 'PS_OS_OUTOFSTOCK_UNPAID';
    const ORDER_STATUS_COD_VALIDATION    = 'PS_OS_COD_VALIDATION';

    // Sibs Order Status
    const ORDER_STATUS_SIBS_PENDING              = 'SIBS_PAYMENT_STATUS_PENDING';
    const ORDER_STATUS_SIBS_AUTHORIZED           = 'SIBS_PAYMENT_STATUS_AUTHORIZED';
    const ORDER_STATUS_SIBS_REFUND_PENDING       = 'SIBS_PAYMENT_STATUS_REFUND_PENDING';
    const ORDER_STATUS_SIBS_PENDING_TRANSLATIONS = [
        'en' => 'Pending payment',
        'pl' => 'Oczekująca płatność',
        'pt' => 'Pagamento pendente',
        'du' => 'In afwachting van betaling',
    ];

    const ORDER_STATUS_SIBS_AUTHORIZED_TRANSLATIONS = [
        'en' => 'Payment authorized',
        'pl' => 'Zakończenie upoważniony',
        'pt' => 'Pagamento autorizado',
        'du' => 'Betaling geautoriseerd',
    ];

    const ORDER_STATUS_SIBS_REFUND_PENDING_TRANSLATIONS = [
        'en' => 'Payment pending refund',
        'pl' => 'Zwrot oczekującej płatności',
        'pt' => 'Pagamento pendente de reembolso',
        'du' => 'Betaling in afwachting van terugbetaling',
    ];

    const ORDER_STATUS_SIBS_PENDING_COLOR        = '#989FA7';
    const ORDER_STATUS_SIBS_AUTHORIZED_COLOR     = '#FCAE1E';
    const ORDER_STATUS_SIBS_REFUND_PENDING_COLOR = '#989FA7';

    // Capture Refund Statuss
    const CAPTURE_REFUND_STATUS_SUCCESS = 'Success';
    const CAPTURE_REFUND_STATUS_PENDING = 'Pending';
    const CAPTURE_REFUND_STATUS_FAILED  = 'Failed';

    // Acknowledgement
    const SIBS_ACK = 'ACK';
    const SIBS_NOK = 'NOK';

    // Credit Card Types
    const SIBS_CREDIT_CARD_AMEX         = 'AMEX';
    const SIBS_CREDIT_CARD_MAESTRO      = 'MAESTRO';
    const SIBS_CREDIT_CARD_MASTER       = 'MASTER';
    const SIBS_CREDIT_CARD_MASTERDEBIT  = 'MASTERDEBIT';
    const SIBS_CREDIT_CARD_VISA         = 'VISA';
    const SIBS_CREDIT_CARD_VISADEBIT    = 'VISADEBIT';
    const SIBS_CREDIT_CARD_VISAELECTRON = 'VISAELECTRON';
    const SIBS_CREDIT_CARD_VPAY         = 'VPAY';
    const SIBS_CREDIT_CARD_XPAY         = 'XPAY';

    // Oneclick
    const SIBS_TOKEN_NONE         = 'NONE';
    const SIBS_TOKEN_TOKENIZATION = 'TOKENIZATION';
    const SIBS_TOKEN_ONECLICK     = 'ONECLICK';
}
