<?php

namespace Sibs;

use FileLogger;

class SibsFileLogger extends FileLogger
{
    /**
     * Overrides
     * Write the message in the log file.
     *
     * @param string $message
     * @param int $level
     *
     * @return bool
     */
    protected function logMessage($message, $level)
    {
        if (! is_string($message)) {
            $message = print_r($message, true);
        }

        $formatted_message = date('Y-m-d H:i:s') . ' ' . $this->level_value[$level] . ' (v' . _PS_VERSION_ . ') ' . $message . "\r\n";

        return (bool) file_put_contents($this->getFilename(), $formatted_message, FILE_APPEND);
    }
}
