<?php

namespace Sibs;

use Configuration;

class SibsUtils
{
    /**
     * Get Credentials.
     *
     * @return array
     */
    public static function getCredentials()
    {
        return [
            'channel_id'  => 'web',
            'token'       => Configuration::get('SIBS_GENERAL_BEARER'),
            'server_mode' => self::getServerMode(),
        ];
    }

    /**
     * Get Server Mode.
     *
     * @return string
     */
    public static function getServerMode()
    {
        return Configuration::get('SIBS_GENERAL_ENVIRONMENT');
    }

    /**
     * Get Test Mode.
     *
     * @param string $paymentMethod
     * @return string
     */
    public static function getTestMode($paymentMethod)
    {
        if (self::getServerMode($paymentMethod) === 'LIVE') {
            return false;
        }

        return 'EXTERNAL';
    }

    /**
     * String Contains.
     *
     * @param string $haystack
     * @param string $needle
     * @return bool
     */
    public static function strContains(string $haystack, string $needle)
    {
        return empty($needle) || strpos($haystack, $needle) !== false;
    }

    /**
     * Replace Message Keys to Data.
     *
     * @param string $message
     * @param array $data
     * @return string
     */
    public static function replaceKeyToData($message, $data)
    {
        foreach ($data as $key => $value) {
            $message = str_replace("[$key]", $value, $message);
        }

        return $message;
    }
}
