{*
* Copyright since 2007 PrestaShop SA and Contributors
* PrestaShop is an International Registered Trademark & Property of PrestaShop SA
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.md.
* It is also available through the world-wide-web at this URL:
* https://opensource.org/licenses/AFL-3.0
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* @author    Revolut
* @copyright Since 2020 Revolut
* @license   https://opensource.org/licenses/AFL-3.0  Academic Free License (AFL 3.0)
*}

<div class="panel">
	<div class="panel-heading">{l s='General Settings' mod='sibs'}</div>
	<div class="form-wrapper">
		<div class="row" style="padding-bottom:5px; padding-right: 5px;">
			<button type="button" id="sibscriterion_form_submit_btn" name="btnSubmit" class="pull-right btn btn-success btn-sm">
				{l s='Add' mod='sibs'}
			</button>
		</div>
		<table class="table table-bordered table-responsive">
			<thead class="thead-default">
				<tr class="column-headers ">
					<th><b>{l s='Terminal ID' mod='sibs'}</b></th>
					<th><b>{l s='Bearer Token' mod='sibs'}</b></th>
					<th><b>{l s='Client ID' mod='sibs'}</b></th>
					<th><b>{l s='Webhook Secret' mod='sibs'}</b></th>
					<th><b>{l s='Environment' mod='sibs'}</b></th>
					<th><b>{l s='Currency' mod='sibs'}</b></th>
					<th> </th>
				</tr>
			</thead>
			<tbody>
				{foreach from=$terminals item='terminal'}
					<tr>
						<td class="fs-6">{$terminal['terminal_code']|escape:'htmlall':'UTF-8'}</td>
						<td class="fs-6 text-break"><code>{$terminal['bearer_token']|truncate:30:'..':true:true}</code></td>
						<td class="fs-6"><code>{$terminal['client_id']|escape:'htmlall':'UTF-8'}</code></td>
						<td class="fs-6"><code>{$terminal['webhook']|escape:'htmlall':'UTF-8'}</code></td>
						<td class="fs-6">{$terminal['environment']|escape:'htmlall':'UTF-8'}</td>
						<td class="fs-6">{$terminal['currency']|escape:'htmlall':'UTF-8'}</td>
						<td class="fs-6">
							<button type="button" value="{$terminal['id']|escape:'htmlall':'UTF-8'}"
								id="terminalEdit" name="btnSubmit" class="btn btn-primary btn-sm">
								{l s='Edit' mod='sibs'}
							</button>
						</td>
					</tr>
				{/foreach}
			</tbody>
		</table>
	</div>
	<div class="panel-footer">
		
	</div>
</div>

<!-- Modal -->
<div class="modal fade" id="editTerminal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="editar_terminal" class="form" autocomplete="off">
				<div class="modal-header">
					<h1 class="modal-title fs-5" id="editModalLabel">
						{l s='Edit Terminal' mod='sibs'}
					</h1>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
					</button>
				</div>
				<div class="modal-body">
					<!-- -->
					<div class="row">
						<div class="form-group">
						    <label class="col-sm-12" for="terminal_code">
								{l s='Terminal ID' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="terminal_code" name="terminal_code">
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="client_id">
								{l s='Client ID' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="client_id" name="client_id">
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="bearer_token">
								{l s='Bearer Token' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="bearer_token" name="bearer_token">
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="webhook_secret">
								{l s='Webhook Secret' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="webhook_secret" name="webhook_secret">
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="environment">
								{l s='Environment' mod='sibs'}
							</label>
						    <select id="environment" name="environment" class="form-control col-sm-12">
						    	{foreach from=$environments item='environment'}
						    		<option value="{$environment|escape:'htmlall':'UTF-8'}">
										{$environment|escape:'htmlall':'UTF-8'}
									</option>
						    	{/foreach}
						    </select>
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="currency">
								{l s='Currency' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="currency" name="currency">
						</div>
					</div>
					
					<!-- -->
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
						{l s='Close' mod='sibs'}
					</button>
					<button type="button" class="btn btn-primary" id="save_edit" value="">
						{l s='Save changes' mod='sibs'}
					</button>
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal -->
<div class="modal fade" id="newTerminal" tabindex="-1" aria-labelledby="newModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="editar_terminal" class="form" autocomplete="off">
				<div class="modal-header">
					<h1 class="modal-title fs-5" id="newModalLabel">						
						{l s='New terminal' mod='sibs'}
					</h1>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<!-- -->
					<div class="row">
						<div class="form-group">
						    <label class="col-sm-12" for="terminal_code">
								{l s='Terminal ID' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="terminal_code" name="terminal_code">
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="client_id">
								{l s='Client ID' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="client_id" name="client_id">
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="bearer_token">
								{l s='Bearer Token' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="bearer_token" name="bearer_token">
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="webhook_secret">
								{l s='Webhook Secret' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="webhook_secret" name="webhook_secret">
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="environment">
								{l s='Environment' mod='sibs'}
							</label>
						    <select id="environment" name="environment" class="form-control col-sm-12" required>
						    	{foreach from=$environments item='environment'}
						    		<option value="{$environment|escape:'htmlall':'UTF-8'}">
										{$environment|escape:'htmlall':'UTF-8'}
									</option>
						    	{/foreach}
						    </select>
						</div>
						<div class="form-group">
						    <label class="col-sm-12" for="currency">
								{l s='Currency' mod='sibs'}
							</label>
						    <input type="text" class="form-control col-sm-12" id="currency" name="currency">
						</div>
					</div>
					
					<!-- -->
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
						{l s='Close' mod='sibs'}
					</button>
					<button type="button" class="btn btn-primary" id="save_new" value="">
						{l s='Save changes' mod='sibs'}
					</button>
				</div>
			</form>
		</div>
	</div>
</div>


<script type="text/javascript">
	$(document).ready(function() {

		$("button#sibscriterion_form_submit_btn").click(function() {
			$('#terminal_code').val("");
			$('#client_id').val("");
			$('#bearer_token').val("");
			$('#webhook_secret').val("");
			$('#environment').val("");
			$('#currency').val("");
			$('#save_edit').val("");
			$("#newTerminal").modal();
		});
		
		$("button#terminalEdit").click(function() {	
			$('#terminal_code').val("");
			$('#client_id').val("");
			$('#bearer_token').val("");
			$('#webhook_secret').val("");
			$('#environment').val("");
			$('#currency').val("");
			$('#save_edit').val("");
			$("#editTerminal").modal();
			var id = $(this).val();

			$.ajax({
				url: '{Context::getContext()->link->getAdminLink('YourAdminController', true)}',
				type: 'POST',
				cache: false,
				dataType: 'json',
				data: {
					ajax: true,
					action: 'doSomeAction', //lowercase with action name
					terminal_id: id,
				},
				success: function(data) {
					$('#terminal_code').val(data.terminal.terminal_code);
					$('#client_id').val(data.terminal.client_id);
					$('#bearer_token').val(data.terminal.bearer_token);
					$('#webhook_secret').val(data.terminal.webhook);
					//$('#environment').val(data.terminal.environment);
					$('#currency').val(data.terminal.currency);
					$('#save_edit').val(data.terminal.id);
					$('#environment option[value="'+ data.terminal.environment+'"]').attr("selected", "selected");
					console.log(data);
				}
			});

		});
		
		$("button#save_edit").click(function() {
			var data_form = $('#editar_terminal').serialize();
			var id = $(this).val();
			
			$.ajax({
			    url: '{Context::getContext()->link->getAdminLink('YourAdminController', true)}',
			    type: 'post',
			    cache: false,
			    dataType: 'json',
			    data: {
					ajax: true,
					action: 'UpdateTerminal', //lowercase with action name
					form:  data_form,
					terminal_id: id,
				},
			    success: function(data) {
			    	console.log("SAVE...");
			    	$('#editTerminal').modal('hide')

			    }
			});
		});
	});
</script>