{*
 * 2007-2019 PrestaShop SA and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0  Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}

{if !empty($id_transaction)}
    {if !empty($refresh_page)}
        {literal}
            <script>
                $(document).ready(function() {
                    location.href = location.href;
                });
            </script>
        {/literal}
    {/if}

    {if (empty($key_refund) && empty($key_sibs_refund))}
        {literal}
            <script>
                $(document).ready(function() {
                    $('.partial-refund-display').prop('disabled', true);
                });
            </script>
        {/literal}
    {/if}

    {literal}
        <script>
            $(document).ready(function() {
                $("button[name=sibsOrderStatusButton]").click(function(e) {
                    // e.preventDefault();
                    if (confirm("{/literal}{l s='Are you sure you wish to process this inquiry? This action cannot be undone' mod='sibs'}{literal}")) {
                        $('button[name=sibsOrderStatus]').click();
                    }
                });

                $("button[name=sibsCaptureButton]").click(function(e) {
                    // e.preventDefault();
                    if (confirm("{/literal}{l s='Are you sure you wish to process this capture? This action cannot be undone' mod='sibs'}{literal}")) {
                        $('button[name=sibsCapture]').click();
                    }
                });

                $("button[name=sibsRefundButton]").click(function(e) {
                    // e.preventDefault();
                    if (confirm("{/literal}{l s='Are you sure you wish to process this refund? This action cannot be undone' mod='sibs'}{literal}")) {
                        $('button[name=sibsRefund]').click();
                    }
                });
            });
        </script>
    {/literal}

    <div class="product-row row">
        <div class="col-md-12 left-column">
            <div class="card mt-2 d-print-none">
                <div class="card-header">
                    <div class="row">
                        <div class="col md-6">
                            <i class="material-icons">credit_card</i>
                            {l s='Payment Information (SIBS)' mod='sibs'}
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row pb-4">
                        <div class="col-6">
                            <strong>
                                {l s='Transaction ID' mod='sibs'}:
                            </strong>
                        </div>
                        <div class="col-6">
                            {$id_transaction|escape:'htmlall':'UTF-8'}
                        </div>
                        <div class="col-6"><strong>{l s='Payment Method' mod='sibs'}:</strong></div>
                        <div class="col-6">{$payment_method|escape:'htmlall':'UTF-8'}</div>

                        <div class="col-6"><strong>{l s='Amount' mod='sibs'}:</strong></div>
                        <div class="col-6">{$amount|escape:'htmlall':'UTF-8'}</div>

                        <div class="col-6"><strong>{l s='Payment Currency' mod='sibs'}:</strong></div>
                        <div class="col-6">{$currency|escape:'htmlall':'UTF-8'}</div>
                    </div>

                    <form method="POST" action="" style="display:inline" id="sibsActionsForm">
                        {if !empty($key_status)}
                            <div class="form-group row">
                                <div class="col-6">
                                    <div class="input-group input-group-sm float-right" style="width: auto;">
                                        <button type="button" style="margin-left:0.5em" class="btn btn-sm btn-primary pull-right" name="sibsOrderStatusButton">
                                            {l s='Manual Update Payment Status' mod='sibs'}
                                        </button>
                                        <button type="submit" style="display:none" name="sibsOrderStatus">
                                        </button>
                                    </div>
                                </div>
                            </div>
                        {/if}
                        
                        {if !empty($key_sibs_capture)}
                            <div class="form-group row">
                                <div class="col-6">
                                    <div class="input-group input-group-sm float-right" style="width: fit-content;">
                                        <input type="number" min="0.00" max="{$amount|escape:'htmlall':'UTF-8'}" step="any" name="capture_amount" 
                                            class="form-control input-group-sm float-right" style="" value="{$amount|escape:'htmlall':'UTF-8'}" />
                                        <div class="input-group-append">
                                            <div class="input-group-text">
                                                {$currency_sign|escape:'htmlall':'UTF-8'}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <button type="button" style="margin-left:0.5em" class="btn btn-sm btn-warning pull-right" name="sibsCaptureButton">
                                        {l s='Capture Amount' mod='sibs'}
                                    </button>
                                    <button type="submit" style="display:none" name="sibsCapture"></button>
                                </div>
                            </div>
                        {/if}
                        
                        {if (!empty($key_refund) || !empty($key_sibs_refund))}
                            <div class="form-group row">
                                <div class="col-6">
                                    <div class="input-group input-group-sm float-right" style="width: fit-content;">
                                        <input type="number" min="0.00" max="{$amount|escape:'htmlall':'UTF-8'}" step="any" name="refund_amount" 
                                            class="form-control form-control-sm float-right" style="" value="{$amount|escape:'htmlall':'UTF-8'}" />
                                        <div class="input-group-append">
                                            <div class="input-group-text">
                                                {$currency_sign|escape:'htmlall':'UTF-8'}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <button type="button" style="margin-left:0.5em;" class="btn btn-sm btn-secondary pull-right" name="sibsRefundButton">
                                        {l s='Refund Amount' mod='sibs'}
                                    </button>
                                    <button type="submit" style="display:none" name="sibsRefund"></button>
                                </div>
                            </div>
                        {/if}
                    </form>
                </div>
            </div>
        </div>
    </div>
{/if}


