{*
 * 2007-2019 PrestaShop SA and Contributors
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2019 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0  Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
{if $module == "sibs"}
    {if !empty($error_message)}
        {literal}
            <script>
                document.body.onload = addErrorElement;

                function addErrorElement() {
                    var errorMessage = "{/literal}{$error_message|escape:'javascript'}{literal}";
                    var errorContent = document.createTextNode(errorMessage);
                    var errorDiv = document.createElement("div");
                    var sp2 = document.getElementById("content");
                    var parentDiv = sp2.parentNode;

                    errorDiv.setAttribute('class', 'alert alert-danger');
                    errorDiv.setAttribute('role', 'alert');
                    errorDiv.setAttribute('data-alert', 'danger');
                    errorDiv.setAttribute('style', 'text-align: center;');
                    errorDiv.appendChild(errorContent);

                    parentDiv.insertBefore(errorDiv, sp2);
                }
            </script>
        {/literal}
    {/if}
{/if}

